// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ServiceFabric
{
    internal class ServiceFabricClusterOperationSource : IOperationSource<ServiceFabricClusterResource>
    {
        private readonly ArmClient _client;

        internal ServiceFabricClusterOperationSource(ArmClient client)
        {
            _client = client;
        }

        ServiceFabricClusterResource IOperationSource<ServiceFabricClusterResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ServiceFabricClusterData.DeserializeServiceFabricClusterData(document.RootElement);
            return new ServiceFabricClusterResource(_client, data);
        }

        async ValueTask<ServiceFabricClusterResource> IOperationSource<ServiceFabricClusterResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ServiceFabricClusterData.DeserializeServiceFabricClusterData(document.RootElement);
            return new ServiceFabricClusterResource(_client, data);
        }
    }
}
