// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ServiceFabric
{
    internal class ServiceFabricApplicationOperationSource : IOperationSource<ServiceFabricApplicationResource>
    {
        private readonly ArmClient _client;

        internal ServiceFabricApplicationOperationSource(ArmClient client)
        {
            _client = client;
        }

        ServiceFabricApplicationResource IOperationSource<ServiceFabricApplicationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ServiceFabricApplicationData.DeserializeServiceFabricApplicationData(document.RootElement);
            return new ServiceFabricApplicationResource(_client, data);
        }

        async ValueTask<ServiceFabricApplicationResource> IOperationSource<ServiceFabricApplicationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ServiceFabricApplicationData.DeserializeServiceFabricApplicationData(document.RootElement);
            return new ServiceFabricApplicationResource(_client, data);
        }
    }
}
