// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.ServiceBus.Models;

namespace Azure.ResourceManager.ServiceBus
{
    /// <summary>
    /// A class representing the ServiceBusQueue data model.
    /// Description of queue Resource.
    /// </summary>
    public partial class ServiceBusQueueData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ServiceBusQueueData"/>. </summary>
        public ServiceBusQueueData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ServiceBusQueueData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="countDetails"> Message Count Details. </param>
        /// <param name="createdOn"> The exact time the message was created. </param>
        /// <param name="updatedOn"> The exact time the message was updated. </param>
        /// <param name="accessedOn"> Last time a message was sent, or the last time there was a receive request to this queue. </param>
        /// <param name="sizeInBytes"> The size of the queue, in bytes. </param>
        /// <param name="messageCount"> The number of messages in the queue. </param>
        /// <param name="lockDuration"> ISO 8601 timespan duration of a peek-lock; that is, the amount of time that the message is locked for other receivers. The maximum value for LockDuration is 5 minutes; the default value is 1 minute. </param>
        /// <param name="maxSizeInMegabytes"> The maximum size of the queue in megabytes, which is the size of memory allocated for the queue. Default is 1024. </param>
        /// <param name="maxMessageSizeInKilobytes"> Maximum size (in KB) of the message payload that can be accepted by the queue. This property is only used in Premium today and default is 1024. </param>
        /// <param name="requiresDuplicateDetection"> A value indicating if this queue requires duplicate detection. </param>
        /// <param name="requiresSession"> A value that indicates whether the queue supports the concept of sessions. </param>
        /// <param name="defaultMessageTimeToLive"> ISO 8601 default message timespan to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself. </param>
        /// <param name="deadLetteringOnMessageExpiration"> A value that indicates whether this queue has dead letter support when a message expires. </param>
        /// <param name="duplicateDetectionHistoryTimeWindow"> ISO 8601 timeSpan structure that defines the duration of the duplicate detection history. The default value is 10 minutes. </param>
        /// <param name="maxDeliveryCount"> The maximum delivery count. A message is automatically deadlettered after this number of deliveries. default value is 10. </param>
        /// <param name="status"> Enumerates the possible values for the status of a messaging entity. </param>
        /// <param name="enableBatchedOperations"> Value that indicates whether server-side batched operations are enabled. </param>
        /// <param name="autoDeleteOnIdle"> ISO 8061 timeSpan idle interval after which the queue is automatically deleted. The minimum duration is 5 minutes. </param>
        /// <param name="enablePartitioning"> A value that indicates whether the queue is to be partitioned across multiple message brokers. </param>
        /// <param name="enableExpress"> A value that indicates whether Express Entities are enabled. An express queue holds a message in memory temporarily before writing it to persistent storage. </param>
        /// <param name="forwardTo"> Queue/Topic name to forward the messages. </param>
        /// <param name="forwardDeadLetteredMessagesTo"> Queue/Topic name to forward the Dead Letter message. </param>
        /// <param name="location"> The geo-location where the resource lives. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ServiceBusQueueData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, MessageCountDetails countDetails, DateTimeOffset? createdOn, DateTimeOffset? updatedOn, DateTimeOffset? accessedOn, long? sizeInBytes, long? messageCount, TimeSpan? lockDuration, int? maxSizeInMegabytes, long? maxMessageSizeInKilobytes, bool? requiresDuplicateDetection, bool? requiresSession, TimeSpan? defaultMessageTimeToLive, bool? deadLetteringOnMessageExpiration, TimeSpan? duplicateDetectionHistoryTimeWindow, int? maxDeliveryCount, ServiceBusMessagingEntityStatus? status, bool? enableBatchedOperations, TimeSpan? autoDeleteOnIdle, bool? enablePartitioning, bool? enableExpress, string forwardTo, string forwardDeadLetteredMessagesTo, AzureLocation? location, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            CountDetails = countDetails;
            CreatedOn = createdOn;
            UpdatedOn = updatedOn;
            AccessedOn = accessedOn;
            SizeInBytes = sizeInBytes;
            MessageCount = messageCount;
            LockDuration = lockDuration;
            MaxSizeInMegabytes = maxSizeInMegabytes;
            MaxMessageSizeInKilobytes = maxMessageSizeInKilobytes;
            RequiresDuplicateDetection = requiresDuplicateDetection;
            RequiresSession = requiresSession;
            DefaultMessageTimeToLive = defaultMessageTimeToLive;
            DeadLetteringOnMessageExpiration = deadLetteringOnMessageExpiration;
            DuplicateDetectionHistoryTimeWindow = duplicateDetectionHistoryTimeWindow;
            MaxDeliveryCount = maxDeliveryCount;
            Status = status;
            EnableBatchedOperations = enableBatchedOperations;
            AutoDeleteOnIdle = autoDeleteOnIdle;
            EnablePartitioning = enablePartitioning;
            EnableExpress = enableExpress;
            ForwardTo = forwardTo;
            ForwardDeadLetteredMessagesTo = forwardDeadLetteredMessagesTo;
            Location = location;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Message Count Details. </summary>
        [WirePath("properties.countDetails")]
        public MessageCountDetails CountDetails { get; }
        /// <summary> The exact time the message was created. </summary>
        [WirePath("properties.createdAt")]
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> The exact time the message was updated. </summary>
        [WirePath("properties.updatedAt")]
        public DateTimeOffset? UpdatedOn { get; }
        /// <summary> Last time a message was sent, or the last time there was a receive request to this queue. </summary>
        [WirePath("properties.accessedAt")]
        public DateTimeOffset? AccessedOn { get; }
        /// <summary> The size of the queue, in bytes. </summary>
        [WirePath("properties.sizeInBytes")]
        public long? SizeInBytes { get; }
        /// <summary> The number of messages in the queue. </summary>
        [WirePath("properties.messageCount")]
        public long? MessageCount { get; }
        /// <summary> ISO 8601 timespan duration of a peek-lock; that is, the amount of time that the message is locked for other receivers. The maximum value for LockDuration is 5 minutes; the default value is 1 minute. </summary>
        [WirePath("properties.lockDuration")]
        public TimeSpan? LockDuration { get; set; }
        /// <summary> The maximum size of the queue in megabytes, which is the size of memory allocated for the queue. Default is 1024. </summary>
        [WirePath("properties.maxSizeInMegabytes")]
        public int? MaxSizeInMegabytes { get; set; }
        /// <summary> Maximum size (in KB) of the message payload that can be accepted by the queue. This property is only used in Premium today and default is 1024. </summary>
        [WirePath("properties.maxMessageSizeInKilobytes")]
        public long? MaxMessageSizeInKilobytes { get; set; }
        /// <summary> A value indicating if this queue requires duplicate detection. </summary>
        [WirePath("properties.requiresDuplicateDetection")]
        public bool? RequiresDuplicateDetection { get; set; }
        /// <summary> A value that indicates whether the queue supports the concept of sessions. </summary>
        [WirePath("properties.requiresSession")]
        public bool? RequiresSession { get; set; }
        /// <summary> ISO 8601 default message timespan to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself. </summary>
        [WirePath("properties.defaultMessageTimeToLive")]
        public TimeSpan? DefaultMessageTimeToLive { get; set; }
        /// <summary> A value that indicates whether this queue has dead letter support when a message expires. </summary>
        [WirePath("properties.deadLetteringOnMessageExpiration")]
        public bool? DeadLetteringOnMessageExpiration { get; set; }
        /// <summary> ISO 8601 timeSpan structure that defines the duration of the duplicate detection history. The default value is 10 minutes. </summary>
        [WirePath("properties.duplicateDetectionHistoryTimeWindow")]
        public TimeSpan? DuplicateDetectionHistoryTimeWindow { get; set; }
        /// <summary> The maximum delivery count. A message is automatically deadlettered after this number of deliveries. default value is 10. </summary>
        [WirePath("properties.maxDeliveryCount")]
        public int? MaxDeliveryCount { get; set; }
        /// <summary> Enumerates the possible values for the status of a messaging entity. </summary>
        [WirePath("properties.status")]
        public ServiceBusMessagingEntityStatus? Status { get; set; }
        /// <summary> Value that indicates whether server-side batched operations are enabled. </summary>
        [WirePath("properties.enableBatchedOperations")]
        public bool? EnableBatchedOperations { get; set; }
        /// <summary> ISO 8061 timeSpan idle interval after which the queue is automatically deleted. The minimum duration is 5 minutes. </summary>
        [WirePath("properties.autoDeleteOnIdle")]
        public TimeSpan? AutoDeleteOnIdle { get; set; }
        /// <summary> A value that indicates whether the queue is to be partitioned across multiple message brokers. </summary>
        [WirePath("properties.enablePartitioning")]
        public bool? EnablePartitioning { get; set; }
        /// <summary> A value that indicates whether Express Entities are enabled. An express queue holds a message in memory temporarily before writing it to persistent storage. </summary>
        [WirePath("properties.enableExpress")]
        public bool? EnableExpress { get; set; }
        /// <summary> Queue/Topic name to forward the messages. </summary>
        [WirePath("properties.forwardTo")]
        public string ForwardTo { get; set; }
        /// <summary> Queue/Topic name to forward the Dead Letter message. </summary>
        [WirePath("properties.forwardDeadLetteredMessagesTo")]
        public string ForwardDeadLetteredMessagesTo { get; set; }
        /// <summary> The geo-location where the resource lives. </summary>
        [WirePath("location")]
        public AzureLocation? Location { get; }
    }
}
