// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ServiceBus.Models
{
    /// <summary> Represents a filter which is a composition of an expression and an action that is executed in the pub/sub pipeline. </summary>
    public partial class ServiceBusSqlFilter
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ServiceBusSqlFilter"/>. </summary>
        public ServiceBusSqlFilter()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ServiceBusSqlFilter"/>. </summary>
        /// <param name="sqlExpression"> The SQL expression. e.g. MyProperty='ABC'. </param>
        /// <param name="compatibilityLevel"> This property is reserved for future use. An integer value showing the compatibility level, currently hard-coded to 20. </param>
        /// <param name="requiresPreprocessing"> Value that indicates whether the rule action requires preprocessing. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ServiceBusSqlFilter(string sqlExpression, int? compatibilityLevel, bool? requiresPreprocessing, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SqlExpression = sqlExpression;
            CompatibilityLevel = compatibilityLevel;
            RequiresPreprocessing = requiresPreprocessing;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The SQL expression. e.g. MyProperty='ABC'. </summary>
        [WirePath("sqlExpression")]
        public string SqlExpression { get; set; }
        /// <summary> This property is reserved for future use. An integer value showing the compatibility level, currently hard-coded to 20. </summary>
        [WirePath("compatibilityLevel")]
        public int? CompatibilityLevel { get; set; }
        /// <summary> Value that indicates whether the rule action requires preprocessing. </summary>
        [WirePath("requiresPreprocessing")]
        public bool? RequiresPreprocessing { get; set; }
    }
}
