// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.ServiceBus.Models
{
    internal static partial class ServiceBusSkuNameExtensions
    {
        public static string ToSerialString(this ServiceBusSkuName value) => value switch
        {
            ServiceBusSkuName.Basic => "Basic",
            ServiceBusSkuName.Standard => "Standard",
            ServiceBusSkuName.Premium => "Premium",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ServiceBusSkuName value.")
        };

        public static ServiceBusSkuName ToServiceBusSkuName(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Basic")) return ServiceBusSkuName.Basic;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Standard")) return ServiceBusSkuName.Standard;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Premium")) return ServiceBusSkuName.Premium;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ServiceBusSkuName value.");
        }
    }
}
