// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceBus.Models
{
    /// <summary> This determines if traffic is allowed over public network. By default it is enabled. </summary>
    public readonly partial struct ServiceBusPublicNetworkAccess : IEquatable<ServiceBusPublicNetworkAccess>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServiceBusPublicNetworkAccess"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServiceBusPublicNetworkAccess(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";
        private const string SecuredByPerimeterValue = "SecuredByPerimeter";

        /// <summary> Enabled. </summary>
        public static ServiceBusPublicNetworkAccess Enabled { get; } = new ServiceBusPublicNetworkAccess(EnabledValue);
        /// <summary> Disabled. </summary>
        public static ServiceBusPublicNetworkAccess Disabled { get; } = new ServiceBusPublicNetworkAccess(DisabledValue);
        /// <summary> SecuredByPerimeter. </summary>
        public static ServiceBusPublicNetworkAccess SecuredByPerimeter { get; } = new ServiceBusPublicNetworkAccess(SecuredByPerimeterValue);
        /// <summary> Determines if two <see cref="ServiceBusPublicNetworkAccess"/> values are the same. </summary>
        public static bool operator ==(ServiceBusPublicNetworkAccess left, ServiceBusPublicNetworkAccess right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServiceBusPublicNetworkAccess"/> values are not the same. </summary>
        public static bool operator !=(ServiceBusPublicNetworkAccess left, ServiceBusPublicNetworkAccess right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServiceBusPublicNetworkAccess"/>. </summary>
        public static implicit operator ServiceBusPublicNetworkAccess(string value) => new ServiceBusPublicNetworkAccess(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServiceBusPublicNetworkAccess other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServiceBusPublicNetworkAccess other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
