// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceBus.Models
{
    /// <summary> Provisioning state of the Private Endpoint Connection. </summary>
    public readonly partial struct ServiceBusPrivateEndpointConnectionProvisioningState : IEquatable<ServiceBusPrivateEndpointConnectionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServiceBusPrivateEndpointConnectionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServiceBusPrivateEndpointConnectionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";

        /// <summary> Creating. </summary>
        public static ServiceBusPrivateEndpointConnectionProvisioningState Creating { get; } = new ServiceBusPrivateEndpointConnectionProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static ServiceBusPrivateEndpointConnectionProvisioningState Updating { get; } = new ServiceBusPrivateEndpointConnectionProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static ServiceBusPrivateEndpointConnectionProvisioningState Deleting { get; } = new ServiceBusPrivateEndpointConnectionProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static ServiceBusPrivateEndpointConnectionProvisioningState Succeeded { get; } = new ServiceBusPrivateEndpointConnectionProvisioningState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static ServiceBusPrivateEndpointConnectionProvisioningState Canceled { get; } = new ServiceBusPrivateEndpointConnectionProvisioningState(CanceledValue);
        /// <summary> Failed. </summary>
        public static ServiceBusPrivateEndpointConnectionProvisioningState Failed { get; } = new ServiceBusPrivateEndpointConnectionProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="ServiceBusPrivateEndpointConnectionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ServiceBusPrivateEndpointConnectionProvisioningState left, ServiceBusPrivateEndpointConnectionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServiceBusPrivateEndpointConnectionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ServiceBusPrivateEndpointConnectionProvisioningState left, ServiceBusPrivateEndpointConnectionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServiceBusPrivateEndpointConnectionProvisioningState"/>. </summary>
        public static implicit operator ServiceBusPrivateEndpointConnectionProvisioningState(string value) => new ServiceBusPrivateEndpointConnectionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServiceBusPrivateEndpointConnectionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServiceBusPrivateEndpointConnectionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
