// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceBus.Models
{
    /// <summary> The IP Filter Action. </summary>
    public readonly partial struct ServiceBusNetworkRuleIPAction : IEquatable<ServiceBusNetworkRuleIPAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServiceBusNetworkRuleIPAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServiceBusNetworkRuleIPAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowValue = "Allow";

        /// <summary> Allow. </summary>
        public static ServiceBusNetworkRuleIPAction Allow { get; } = new ServiceBusNetworkRuleIPAction(AllowValue);
        /// <summary> Determines if two <see cref="ServiceBusNetworkRuleIPAction"/> values are the same. </summary>
        public static bool operator ==(ServiceBusNetworkRuleIPAction left, ServiceBusNetworkRuleIPAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServiceBusNetworkRuleIPAction"/> values are not the same. </summary>
        public static bool operator !=(ServiceBusNetworkRuleIPAction left, ServiceBusNetworkRuleIPAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServiceBusNetworkRuleIPAction"/>. </summary>
        public static implicit operator ServiceBusNetworkRuleIPAction(string value) => new ServiceBusNetworkRuleIPAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServiceBusNetworkRuleIPAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServiceBusNetworkRuleIPAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
