// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.ServiceBus.Models
{
    internal static partial class ServiceBusNameUnavailableReasonExtensions
    {
        public static string ToSerialString(this ServiceBusNameUnavailableReason value) => value switch
        {
            ServiceBusNameUnavailableReason.None => "None",
            ServiceBusNameUnavailableReason.InvalidName => "InvalidName",
            ServiceBusNameUnavailableReason.SubscriptionIsDisabled => "SubscriptionIsDisabled",
            ServiceBusNameUnavailableReason.NameInUse => "NameInUse",
            ServiceBusNameUnavailableReason.NameInLockdown => "NameInLockdown",
            ServiceBusNameUnavailableReason.TooManyNamespaceInCurrentSubscription => "TooManyNamespaceInCurrentSubscription",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ServiceBusNameUnavailableReason value.")
        };

        public static ServiceBusNameUnavailableReason ToServiceBusNameUnavailableReason(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "None")) return ServiceBusNameUnavailableReason.None;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "InvalidName")) return ServiceBusNameUnavailableReason.InvalidName;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "SubscriptionIsDisabled")) return ServiceBusNameUnavailableReason.SubscriptionIsDisabled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NameInUse")) return ServiceBusNameUnavailableReason.NameInUse;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NameInLockdown")) return ServiceBusNameUnavailableReason.NameInLockdown;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "TooManyNamespaceInCurrentSubscription")) return ServiceBusNameUnavailableReason.TooManyNamespaceInCurrentSubscription;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ServiceBusNameUnavailableReason value.");
        }
    }
}
