// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.ServiceBus.Models
{
    internal static partial class ServiceBusMessagingEntityStatusExtensions
    {
        public static string ToSerialString(this ServiceBusMessagingEntityStatus value) => value switch
        {
            ServiceBusMessagingEntityStatus.Unknown => "Unknown",
            ServiceBusMessagingEntityStatus.Active => "Active",
            ServiceBusMessagingEntityStatus.Disabled => "Disabled",
            ServiceBusMessagingEntityStatus.Restoring => "Restoring",
            ServiceBusMessagingEntityStatus.SendDisabled => "SendDisabled",
            ServiceBusMessagingEntityStatus.ReceiveDisabled => "ReceiveDisabled",
            ServiceBusMessagingEntityStatus.Creating => "Creating",
            ServiceBusMessagingEntityStatus.Deleting => "Deleting",
            ServiceBusMessagingEntityStatus.Renaming => "Renaming",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ServiceBusMessagingEntityStatus value.")
        };

        public static ServiceBusMessagingEntityStatus ToServiceBusMessagingEntityStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Unknown")) return ServiceBusMessagingEntityStatus.Unknown;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Active")) return ServiceBusMessagingEntityStatus.Active;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Disabled")) return ServiceBusMessagingEntityStatus.Disabled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Restoring")) return ServiceBusMessagingEntityStatus.Restoring;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "SendDisabled")) return ServiceBusMessagingEntityStatus.SendDisabled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ReceiveDisabled")) return ServiceBusMessagingEntityStatus.ReceiveDisabled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Creating")) return ServiceBusMessagingEntityStatus.Creating;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Deleting")) return ServiceBusMessagingEntityStatus.Deleting;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Renaming")) return ServiceBusMessagingEntityStatus.Renaming;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ServiceBusMessagingEntityStatus value.");
        }
    }
}
