// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceBus.Models
{
    /// <summary> Enumerates the possible value of keySource for Encryption. </summary>
    public readonly partial struct ServiceBusEncryptionKeySource : IEquatable<ServiceBusEncryptionKeySource>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServiceBusEncryptionKeySource"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServiceBusEncryptionKeySource(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftKeyVaultValue = "Microsoft.KeyVault";

        /// <summary> Microsoft.KeyVault. </summary>
        public static ServiceBusEncryptionKeySource MicrosoftKeyVault { get; } = new ServiceBusEncryptionKeySource(MicrosoftKeyVaultValue);
        /// <summary> Determines if two <see cref="ServiceBusEncryptionKeySource"/> values are the same. </summary>
        public static bool operator ==(ServiceBusEncryptionKeySource left, ServiceBusEncryptionKeySource right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServiceBusEncryptionKeySource"/> values are not the same. </summary>
        public static bool operator !=(ServiceBusEncryptionKeySource left, ServiceBusEncryptionKeySource right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServiceBusEncryptionKeySource"/>. </summary>
        public static implicit operator ServiceBusEncryptionKeySource(string value) => new ServiceBusEncryptionKeySource(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServiceBusEncryptionKeySource other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServiceBusEncryptionKeySource other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
