// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.ServiceBus.Models
{
    internal static partial class ServiceBusDisasterRecoveryRoleExtensions
    {
        public static string ToSerialString(this ServiceBusDisasterRecoveryRole value) => value switch
        {
            ServiceBusDisasterRecoveryRole.Primary => "Primary",
            ServiceBusDisasterRecoveryRole.PrimaryNotReplicating => "PrimaryNotReplicating",
            ServiceBusDisasterRecoveryRole.Secondary => "Secondary",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ServiceBusDisasterRecoveryRole value.")
        };

        public static ServiceBusDisasterRecoveryRole ToServiceBusDisasterRecoveryRole(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Primary")) return ServiceBusDisasterRecoveryRole.Primary;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "PrimaryNotReplicating")) return ServiceBusDisasterRecoveryRole.PrimaryNotReplicating;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Secondary")) return ServiceBusDisasterRecoveryRole.Secondary;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ServiceBusDisasterRecoveryRole value.");
        }
    }
}
