// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.ServiceBus.Models
{
    internal static partial class ServiceBusAccessKeyTypeExtensions
    {
        public static string ToSerialString(this ServiceBusAccessKeyType value) => value switch
        {
            ServiceBusAccessKeyType.PrimaryKey => "PrimaryKey",
            ServiceBusAccessKeyType.SecondaryKey => "SecondaryKey",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ServiceBusAccessKeyType value.")
        };

        public static ServiceBusAccessKeyType ToServiceBusAccessKeyType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "PrimaryKey")) return ServiceBusAccessKeyType.PrimaryKey;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "SecondaryKey")) return ServiceBusAccessKeyType.SecondaryKey;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ServiceBusAccessKeyType value.");
        }
    }
}
