// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceBus.Models
{
    /// <summary> The MigrationConfigurationName. </summary>
    public readonly partial struct MigrationConfigurationName : IEquatable<MigrationConfigurationName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MigrationConfigurationName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MigrationConfigurationName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "$default";

        /// <summary> $default. </summary>
        public static MigrationConfigurationName Default { get; } = new MigrationConfigurationName(DefaultValue);
        /// <summary> Determines if two <see cref="MigrationConfigurationName"/> values are the same. </summary>
        public static bool operator ==(MigrationConfigurationName left, MigrationConfigurationName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MigrationConfigurationName"/> values are not the same. </summary>
        public static bool operator !=(MigrationConfigurationName left, MigrationConfigurationName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MigrationConfigurationName"/>. </summary>
        public static implicit operator MigrationConfigurationName(string value) => new MigrationConfigurationName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MigrationConfigurationName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MigrationConfigurationName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
