// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ServiceBus.Models
{
    /// <summary> The result of the List migrationConfigurations operation. </summary>
    internal partial class MigrationConfigListResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MigrationConfigListResult"/>. </summary>
        internal MigrationConfigListResult()
        {
            Value = new ChangeTrackingList<MigrationConfigurationData>();
        }

        /// <summary> Initializes a new instance of <see cref="MigrationConfigListResult"/>. </summary>
        /// <param name="value"> List of Migration Configs. </param>
        /// <param name="nextLink"> Link to the next set of results. Not empty if Value contains incomplete list of migrationConfigurations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MigrationConfigListResult(IReadOnlyList<MigrationConfigurationData> value, string nextLink, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            NextLink = nextLink;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of Migration Configs. </summary>
        public IReadOnlyList<MigrationConfigurationData> Value { get; }
        /// <summary> Link to the next set of results. Not empty if Value contains incomplete list of migrationConfigurations. </summary>
        public string NextLink { get; }
    }
}
