// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ServiceBus.Models
{
    /// <summary> Message Count Details. </summary>
    public partial class MessageCountDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MessageCountDetails"/>. </summary>
        internal MessageCountDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MessageCountDetails"/>. </summary>
        /// <param name="activeMessageCount"> Number of active messages in the queue, topic, or subscription. </param>
        /// <param name="deadLetterMessageCount"> Number of messages that are dead lettered. </param>
        /// <param name="scheduledMessageCount"> Number of scheduled messages. </param>
        /// <param name="transferMessageCount"> Number of messages transferred to another queue, topic, or subscription. </param>
        /// <param name="transferDeadLetterMessageCount"> Number of messages transferred into dead letters. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MessageCountDetails(long? activeMessageCount, long? deadLetterMessageCount, long? scheduledMessageCount, long? transferMessageCount, long? transferDeadLetterMessageCount, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ActiveMessageCount = activeMessageCount;
            DeadLetterMessageCount = deadLetterMessageCount;
            ScheduledMessageCount = scheduledMessageCount;
            TransferMessageCount = transferMessageCount;
            TransferDeadLetterMessageCount = transferDeadLetterMessageCount;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Number of active messages in the queue, topic, or subscription. </summary>
        [WirePath("activeMessageCount")]
        public long? ActiveMessageCount { get; }
        /// <summary> Number of messages that are dead lettered. </summary>
        [WirePath("deadLetterMessageCount")]
        public long? DeadLetterMessageCount { get; }
        /// <summary> Number of scheduled messages. </summary>
        [WirePath("scheduledMessageCount")]
        public long? ScheduledMessageCount { get; }
        /// <summary> Number of messages transferred to another queue, topic, or subscription. </summary>
        [WirePath("transferMessageCount")]
        public long? TransferMessageCount { get; }
        /// <summary> Number of messages transferred into dead letters. </summary>
        [WirePath("transferDeadLetterMessageCount")]
        public long? TransferDeadLetterMessageCount { get; }
    }
}
