// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ServiceBus.Models
{
    /// <summary> Safe failover is to indicate the service should wait for pending replication to finish before switching to the secondary. </summary>
    public partial class FailoverProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FailoverProperties"/>. </summary>
        public FailoverProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="FailoverProperties"/>. </summary>
        /// <param name="isSafeFailover"> Safe failover is to indicate the service should wait for pending replication to finish before switching to the secondary. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FailoverProperties(bool? isSafeFailover, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsSafeFailover = isSafeFailover;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Safe failover is to indicate the service should wait for pending replication to finish before switching to the secondary. </summary>
        [WirePath("properties.IsSafeFailover")]
        public bool? IsSafeFailover { get; set; }
    }
}
