// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ServiceBus
{
    internal class ServiceBusNamespaceOperationSource : IOperationSource<ServiceBusNamespaceResource>
    {
        private readonly ArmClient _client;

        internal ServiceBusNamespaceOperationSource(ArmClient client)
        {
            _client = client;
        }

        ServiceBusNamespaceResource IOperationSource<ServiceBusNamespaceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ServiceBusNamespaceData.DeserializeServiceBusNamespaceData(document.RootElement);
            return new ServiceBusNamespaceResource(_client, data);
        }

        async ValueTask<ServiceBusNamespaceResource> IOperationSource<ServiceBusNamespaceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ServiceBusNamespaceData.DeserializeServiceBusNamespaceData(document.RootElement);
            return new ServiceBusNamespaceResource(_client, data);
        }
    }
}
