// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ServiceBus.Models;

namespace Azure.ResourceManager.ServiceBus.Samples
{
    public partial class Sample_ServiceBusTopicAuthorizationRuleResource
    {
        // TopicAuthorizationRuleCreate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_TopicAuthorizationRuleCreate()
        {
            // Generated from example definition: specification/servicebus/resource-manager/Microsoft.ServiceBus/preview/2022-10-01-preview/examples/Topics/SBTopicAuthorizationRuleCreate.json
            // this example is just showing the usage of "TopicAuthorizationRules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceBusTopicAuthorizationRuleResource created on azure
            // for more information of creating ServiceBusTopicAuthorizationRuleResource, please refer to the document of ServiceBusTopicAuthorizationRuleResource
            string subscriptionId = "5f750a97-50d9-4e36-8081-c9ee4c0210d4";
            string resourceGroupName = "ArunMonocle";
            string namespaceName = "sdk-Namespace-6261";
            string topicName = "sdk-Topics-1984";
            string authorizationRuleName = "sdk-AuthRules-4310";
            ResourceIdentifier serviceBusTopicAuthorizationRuleResourceId = ServiceBusTopicAuthorizationRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, topicName, authorizationRuleName);
            ServiceBusTopicAuthorizationRuleResource serviceBusTopicAuthorizationRule = client.GetServiceBusTopicAuthorizationRuleResource(serviceBusTopicAuthorizationRuleResourceId);

            // invoke the operation
            ServiceBusAuthorizationRuleData data = new ServiceBusAuthorizationRuleData()
            {
                Rights =
{
ServiceBusAccessRight.Listen,ServiceBusAccessRight.Send
},
            };
            ArmOperation<ServiceBusTopicAuthorizationRuleResource> lro = await serviceBusTopicAuthorizationRule.UpdateAsync(WaitUntil.Completed, data);
            ServiceBusTopicAuthorizationRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ServiceBusAuthorizationRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // TopicAuthorizationRuleGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_TopicAuthorizationRuleGet()
        {
            // Generated from example definition: specification/servicebus/resource-manager/Microsoft.ServiceBus/preview/2022-10-01-preview/examples/Topics/SBTopicAuthorizationRuleGet.json
            // this example is just showing the usage of "TopicAuthorizationRules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceBusTopicAuthorizationRuleResource created on azure
            // for more information of creating ServiceBusTopicAuthorizationRuleResource, please refer to the document of ServiceBusTopicAuthorizationRuleResource
            string subscriptionId = "5f750a97-50d9-4e36-8081-c9ee4c0210d4";
            string resourceGroupName = "ArunMonocle";
            string namespaceName = "sdk-Namespace-6261";
            string topicName = "sdk-Topics-1984";
            string authorizationRuleName = "sdk-AuthRules-4310";
            ResourceIdentifier serviceBusTopicAuthorizationRuleResourceId = ServiceBusTopicAuthorizationRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, topicName, authorizationRuleName);
            ServiceBusTopicAuthorizationRuleResource serviceBusTopicAuthorizationRule = client.GetServiceBusTopicAuthorizationRuleResource(serviceBusTopicAuthorizationRuleResourceId);

            // invoke the operation
            ServiceBusTopicAuthorizationRuleResource result = await serviceBusTopicAuthorizationRule.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ServiceBusAuthorizationRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // TopicAuthorizationRuleDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_TopicAuthorizationRuleDelete()
        {
            // Generated from example definition: specification/servicebus/resource-manager/Microsoft.ServiceBus/preview/2022-10-01-preview/examples/Topics/SBTopicAuthorizationRuleDelete.json
            // this example is just showing the usage of "TopicAuthorizationRules_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceBusTopicAuthorizationRuleResource created on azure
            // for more information of creating ServiceBusTopicAuthorizationRuleResource, please refer to the document of ServiceBusTopicAuthorizationRuleResource
            string subscriptionId = "5f750a97-50d9-4e36-8081-c9ee4c0210d4";
            string resourceGroupName = "ArunMonocle";
            string namespaceName = "sdk-Namespace-6261";
            string topicName = "sdk-Topics-1984";
            string authorizationRuleName = "sdk-AuthRules-4310";
            ResourceIdentifier serviceBusTopicAuthorizationRuleResourceId = ServiceBusTopicAuthorizationRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, topicName, authorizationRuleName);
            ServiceBusTopicAuthorizationRuleResource serviceBusTopicAuthorizationRule = client.GetServiceBusTopicAuthorizationRuleResource(serviceBusTopicAuthorizationRuleResourceId);

            // invoke the operation
            await serviceBusTopicAuthorizationRule.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // TopicAuthorizationRuleListKey
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetKeys_TopicAuthorizationRuleListKey()
        {
            // Generated from example definition: specification/servicebus/resource-manager/Microsoft.ServiceBus/preview/2022-10-01-preview/examples/Topics/SBTopicAuthorizationRuleListKey.json
            // this example is just showing the usage of "TopicAuthorizationRules_ListKeys" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceBusTopicAuthorizationRuleResource created on azure
            // for more information of creating ServiceBusTopicAuthorizationRuleResource, please refer to the document of ServiceBusTopicAuthorizationRuleResource
            string subscriptionId = "e2f361f0-3b27-4503-a9cc-21cfba380093";
            string resourceGroupName = "Default-ServiceBus-WestUS";
            string namespaceName = "sdk-Namespace8408";
            string topicName = "sdk-Topics2075";
            string authorizationRuleName = "sdk-Authrules5067";
            ResourceIdentifier serviceBusTopicAuthorizationRuleResourceId = ServiceBusTopicAuthorizationRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, topicName, authorizationRuleName);
            ServiceBusTopicAuthorizationRuleResource serviceBusTopicAuthorizationRule = client.GetServiceBusTopicAuthorizationRuleResource(serviceBusTopicAuthorizationRuleResourceId);

            // invoke the operation
            ServiceBusAccessKeys result = await serviceBusTopicAuthorizationRule.GetKeysAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // TopicAuthorizationRuleRegenerateKey
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RegenerateKeys_TopicAuthorizationRuleRegenerateKey()
        {
            // Generated from example definition: specification/servicebus/resource-manager/Microsoft.ServiceBus/preview/2022-10-01-preview/examples/Topics/SBTopicAuthorizationRuleRegenerateKey.json
            // this example is just showing the usage of "TopicAuthorizationRules_RegenerateKeys" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceBusTopicAuthorizationRuleResource created on azure
            // for more information of creating ServiceBusTopicAuthorizationRuleResource, please refer to the document of ServiceBusTopicAuthorizationRuleResource
            string subscriptionId = "e2f361f0-3b27-4503-a9cc-21cfba380093";
            string resourceGroupName = "Default-ServiceBus-WestUS";
            string namespaceName = "sdk-Namespace8408";
            string topicName = "sdk-Topics2075";
            string authorizationRuleName = "sdk-Authrules5067";
            ResourceIdentifier serviceBusTopicAuthorizationRuleResourceId = ServiceBusTopicAuthorizationRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, topicName, authorizationRuleName);
            ServiceBusTopicAuthorizationRuleResource serviceBusTopicAuthorizationRule = client.GetServiceBusTopicAuthorizationRuleResource(serviceBusTopicAuthorizationRuleResourceId);

            // invoke the operation
            ServiceBusRegenerateAccessKeyContent content = new ServiceBusRegenerateAccessKeyContent(ServiceBusAccessKeyType.PrimaryKey);
            ServiceBusAccessKeys result = await serviceBusTopicAuthorizationRule.RegenerateKeysAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
