// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.ServiceBus.Samples
{
    public partial class Sample_ServiceBusSubscriptionCollection
    {
        // SubscriptionListByTopic
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_SubscriptionListByTopic()
        {
            // Generated from example definition: specification/servicebus/resource-manager/Microsoft.ServiceBus/preview/2022-10-01-preview/examples/Subscriptions/SBSubscriptionListByTopic.json
            // this example is just showing the usage of "Subscriptions_ListByTopic" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceBusTopicResource created on azure
            // for more information of creating ServiceBusTopicResource, please refer to the document of ServiceBusTopicResource
            string subscriptionId = "5{Subscriptionid}";
            string resourceGroupName = "ResourceGroup";
            string namespaceName = "sdk-Namespace-1349";
            string topicName = "sdk-Topics-8740";
            ResourceIdentifier serviceBusTopicResourceId = ServiceBusTopicResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, topicName);
            ServiceBusTopicResource serviceBusTopic = client.GetServiceBusTopicResource(serviceBusTopicResourceId);

            // get the collection of this ServiceBusSubscriptionResource
            ServiceBusSubscriptionCollection collection = serviceBusTopic.GetServiceBusSubscriptions();

            // invoke the operation and iterate over the result
            await foreach (ServiceBusSubscriptionResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ServiceBusSubscriptionData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // SubscriptionCreate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_SubscriptionCreate()
        {
            // Generated from example definition: specification/servicebus/resource-manager/Microsoft.ServiceBus/preview/2022-10-01-preview/examples/Subscriptions/SBSubscriptionCreate.json
            // this example is just showing the usage of "Subscriptions_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceBusTopicResource created on azure
            // for more information of creating ServiceBusTopicResource, please refer to the document of ServiceBusTopicResource
            string subscriptionId = "Subscriptionid";
            string resourceGroupName = "ResourceGroup";
            string namespaceName = "sdk-Namespace-1349";
            string topicName = "sdk-Topics-8740";
            ResourceIdentifier serviceBusTopicResourceId = ServiceBusTopicResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, topicName);
            ServiceBusTopicResource serviceBusTopic = client.GetServiceBusTopicResource(serviceBusTopicResourceId);

            // get the collection of this ServiceBusSubscriptionResource
            ServiceBusSubscriptionCollection collection = serviceBusTopic.GetServiceBusSubscriptions();

            // invoke the operation
            string subscriptionName = "sdk-Subscriptions-2178";
            ServiceBusSubscriptionData data = new ServiceBusSubscriptionData()
            {
                EnableBatchedOperations = true,
            };
            ArmOperation<ServiceBusSubscriptionResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, subscriptionName, data);
            ServiceBusSubscriptionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ServiceBusSubscriptionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // SubscriptionGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_SubscriptionGet()
        {
            // Generated from example definition: specification/servicebus/resource-manager/Microsoft.ServiceBus/preview/2022-10-01-preview/examples/Subscriptions/SBSubscriptionGet.json
            // this example is just showing the usage of "Subscriptions_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceBusTopicResource created on azure
            // for more information of creating ServiceBusTopicResource, please refer to the document of ServiceBusTopicResource
            string subscriptionId = "Subscriptionid";
            string resourceGroupName = "ResourceGroup";
            string namespaceName = "sdk-Namespace-1349";
            string topicName = "sdk-Topics-8740";
            ResourceIdentifier serviceBusTopicResourceId = ServiceBusTopicResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, topicName);
            ServiceBusTopicResource serviceBusTopic = client.GetServiceBusTopicResource(serviceBusTopicResourceId);

            // get the collection of this ServiceBusSubscriptionResource
            ServiceBusSubscriptionCollection collection = serviceBusTopic.GetServiceBusSubscriptions();

            // invoke the operation
            string subscriptionName = "sdk-Subscriptions-2178";
            ServiceBusSubscriptionResource result = await collection.GetAsync(subscriptionName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ServiceBusSubscriptionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // SubscriptionGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_SubscriptionGet()
        {
            // Generated from example definition: specification/servicebus/resource-manager/Microsoft.ServiceBus/preview/2022-10-01-preview/examples/Subscriptions/SBSubscriptionGet.json
            // this example is just showing the usage of "Subscriptions_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceBusTopicResource created on azure
            // for more information of creating ServiceBusTopicResource, please refer to the document of ServiceBusTopicResource
            string subscriptionId = "Subscriptionid";
            string resourceGroupName = "ResourceGroup";
            string namespaceName = "sdk-Namespace-1349";
            string topicName = "sdk-Topics-8740";
            ResourceIdentifier serviceBusTopicResourceId = ServiceBusTopicResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, topicName);
            ServiceBusTopicResource serviceBusTopic = client.GetServiceBusTopicResource(serviceBusTopicResourceId);

            // get the collection of this ServiceBusSubscriptionResource
            ServiceBusSubscriptionCollection collection = serviceBusTopic.GetServiceBusSubscriptions();

            // invoke the operation
            string subscriptionName = "sdk-Subscriptions-2178";
            bool result = await collection.ExistsAsync(subscriptionName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // SubscriptionGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_SubscriptionGet()
        {
            // Generated from example definition: specification/servicebus/resource-manager/Microsoft.ServiceBus/preview/2022-10-01-preview/examples/Subscriptions/SBSubscriptionGet.json
            // this example is just showing the usage of "Subscriptions_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceBusTopicResource created on azure
            // for more information of creating ServiceBusTopicResource, please refer to the document of ServiceBusTopicResource
            string subscriptionId = "Subscriptionid";
            string resourceGroupName = "ResourceGroup";
            string namespaceName = "sdk-Namespace-1349";
            string topicName = "sdk-Topics-8740";
            ResourceIdentifier serviceBusTopicResourceId = ServiceBusTopicResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, topicName);
            ServiceBusTopicResource serviceBusTopic = client.GetServiceBusTopicResource(serviceBusTopicResourceId);

            // get the collection of this ServiceBusSubscriptionResource
            ServiceBusSubscriptionCollection collection = serviceBusTopic.GetServiceBusSubscriptions();

            // invoke the operation
            string subscriptionName = "sdk-Subscriptions-2178";
            NullableResponse<ServiceBusSubscriptionResource> response = await collection.GetIfExistsAsync(subscriptionName);
            ServiceBusSubscriptionResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ServiceBusSubscriptionData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
