// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ServiceBus.Models;

namespace Azure.ResourceManager.ServiceBus.Samples
{
    public partial class Sample_ServiceBusNetworkRuleSetResource
    {
        // NameSpaceNetworkRuleSetCreate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_NameSpaceNetworkRuleSetCreate()
        {
            // Generated from example definition: specification/servicebus/resource-manager/Microsoft.ServiceBus/preview/2022-10-01-preview/examples/NameSpaces/VirtualNetworkRule/SBNetworkRuleSetCreate.json
            // this example is just showing the usage of "Namespaces_CreateOrUpdateNetworkRuleSet" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceBusNetworkRuleSetResource created on azure
            // for more information of creating ServiceBusNetworkRuleSetResource, please refer to the document of ServiceBusNetworkRuleSetResource
            string subscriptionId = "Subscription";
            string resourceGroupName = "ResourceGroup";
            string namespaceName = "sdk-Namespace-6019";
            ResourceIdentifier serviceBusNetworkRuleSetResourceId = ServiceBusNetworkRuleSetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName);
            ServiceBusNetworkRuleSetResource serviceBusNetworkRuleSet = client.GetServiceBusNetworkRuleSetResource(serviceBusNetworkRuleSetResourceId);

            // invoke the operation
            ServiceBusNetworkRuleSetData data = new ServiceBusNetworkRuleSetData()
            {
                DefaultAction = ServiceBusNetworkRuleSetDefaultAction.Deny,
                VirtualNetworkRules =
{
new ServiceBusNetworkRuleSetVirtualNetworkRules()
{
SubnetId = new ResourceIdentifier("/subscriptions/854d368f-1828-428f-8f3c-f2affa9b2f7d/resourcegroups/alitest/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet2"),
IgnoreMissingVnetServiceEndpoint = true,
},new ServiceBusNetworkRuleSetVirtualNetworkRules()
{
SubnetId = new ResourceIdentifier("/subscriptions/854d368f-1828-428f-8f3c-f2affa9b2f7d/resourcegroups/alitest/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet3"),
IgnoreMissingVnetServiceEndpoint = false,
},new ServiceBusNetworkRuleSetVirtualNetworkRules()
{
SubnetId = new ResourceIdentifier("/subscriptions/854d368f-1828-428f-8f3c-f2affa9b2f7d/resourcegroups/alitest/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet6"),
IgnoreMissingVnetServiceEndpoint = false,
}
},
                IPRules =
{
new ServiceBusNetworkRuleSetIPRules()
{
IPMask = "1.1.1.1",
Action = ServiceBusNetworkRuleIPAction.Allow,
},new ServiceBusNetworkRuleSetIPRules()
{
IPMask = "1.1.1.2",
Action = ServiceBusNetworkRuleIPAction.Allow,
},new ServiceBusNetworkRuleSetIPRules()
{
IPMask = "1.1.1.3",
Action = ServiceBusNetworkRuleIPAction.Allow,
},new ServiceBusNetworkRuleSetIPRules()
{
IPMask = "1.1.1.4",
Action = ServiceBusNetworkRuleIPAction.Allow,
},new ServiceBusNetworkRuleSetIPRules()
{
IPMask = "1.1.1.5",
Action = ServiceBusNetworkRuleIPAction.Allow,
}
},
            };
            ArmOperation<ServiceBusNetworkRuleSetResource> lro = await serviceBusNetworkRuleSet.CreateOrUpdateAsync(WaitUntil.Completed, data);
            ServiceBusNetworkRuleSetResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ServiceBusNetworkRuleSetData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // NameSpaceNetworkRuleSetGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_NameSpaceNetworkRuleSetGet()
        {
            // Generated from example definition: specification/servicebus/resource-manager/Microsoft.ServiceBus/preview/2022-10-01-preview/examples/NameSpaces/VirtualNetworkRule/SBNetworkRuleSetGet.json
            // this example is just showing the usage of "Namespaces_GetNetworkRuleSet" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceBusNetworkRuleSetResource created on azure
            // for more information of creating ServiceBusNetworkRuleSetResource, please refer to the document of ServiceBusNetworkRuleSetResource
            string subscriptionId = "Subscription";
            string resourceGroupName = "ResourceGroup";
            string namespaceName = "sdk-Namespace-6019";
            ResourceIdentifier serviceBusNetworkRuleSetResourceId = ServiceBusNetworkRuleSetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName);
            ServiceBusNetworkRuleSetResource serviceBusNetworkRuleSet = client.GetServiceBusNetworkRuleSetResource(serviceBusNetworkRuleSetResourceId);

            // invoke the operation
            ServiceBusNetworkRuleSetResource result = await serviceBusNetworkRuleSet.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ServiceBusNetworkRuleSetData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
