// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.ServiceBus.Samples
{
    public partial class Sample_ServiceBusDisasterRecoveryAuthorizationRuleCollection
    {
        // NameSpaceAuthorizationRuleListAll
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_NameSpaceAuthorizationRuleListAll()
        {
            // Generated from example definition: specification/servicebus/resource-manager/Microsoft.ServiceBus/preview/2022-10-01-preview/examples/disasterRecoveryConfigs/SBAliasAuthorizationRuleListAll.json
            // this example is just showing the usage of "DisasterRecoveryAuthorizationRules_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceBusDisasterRecoveryResource created on azure
            // for more information of creating ServiceBusDisasterRecoveryResource, please refer to the document of ServiceBusDisasterRecoveryResource
            string subscriptionId = "exampleSubscriptionId";
            string resourceGroupName = "exampleResourceGroup";
            string namespaceName = "sdk-Namespace-9080";
            string @alias = "sdk-DisasterRecovery-4047";
            ResourceIdentifier serviceBusDisasterRecoveryResourceId = ServiceBusDisasterRecoveryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, @alias);
            ServiceBusDisasterRecoveryResource serviceBusDisasterRecovery = client.GetServiceBusDisasterRecoveryResource(serviceBusDisasterRecoveryResourceId);

            // get the collection of this ServiceBusDisasterRecoveryAuthorizationRuleResource
            ServiceBusDisasterRecoveryAuthorizationRuleCollection collection = serviceBusDisasterRecovery.GetServiceBusDisasterRecoveryAuthorizationRules();

            // invoke the operation and iterate over the result
            await foreach (ServiceBusDisasterRecoveryAuthorizationRuleResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ServiceBusAuthorizationRuleData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // DisasterRecoveryConfigsAuthorizationRuleGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_DisasterRecoveryConfigsAuthorizationRuleGet()
        {
            // Generated from example definition: specification/servicebus/resource-manager/Microsoft.ServiceBus/preview/2022-10-01-preview/examples/disasterRecoveryConfigs/SBAliasAuthorizationRuleGet.json
            // this example is just showing the usage of "DisasterRecoveryAuthorizationRules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceBusDisasterRecoveryResource created on azure
            // for more information of creating ServiceBusDisasterRecoveryResource, please refer to the document of ServiceBusDisasterRecoveryResource
            string subscriptionId = "exampleSubscriptionId";
            string resourceGroupName = "exampleResourceGroup";
            string namespaceName = "sdk-Namespace-9080";
            string @alias = "sdk-DisasterRecovery-4879";
            ResourceIdentifier serviceBusDisasterRecoveryResourceId = ServiceBusDisasterRecoveryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, @alias);
            ServiceBusDisasterRecoveryResource serviceBusDisasterRecovery = client.GetServiceBusDisasterRecoveryResource(serviceBusDisasterRecoveryResourceId);

            // get the collection of this ServiceBusDisasterRecoveryAuthorizationRuleResource
            ServiceBusDisasterRecoveryAuthorizationRuleCollection collection = serviceBusDisasterRecovery.GetServiceBusDisasterRecoveryAuthorizationRules();

            // invoke the operation
            string authorizationRuleName = "sdk-Authrules-4879";
            ServiceBusDisasterRecoveryAuthorizationRuleResource result = await collection.GetAsync(authorizationRuleName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ServiceBusAuthorizationRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // DisasterRecoveryConfigsAuthorizationRuleGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_DisasterRecoveryConfigsAuthorizationRuleGet()
        {
            // Generated from example definition: specification/servicebus/resource-manager/Microsoft.ServiceBus/preview/2022-10-01-preview/examples/disasterRecoveryConfigs/SBAliasAuthorizationRuleGet.json
            // this example is just showing the usage of "DisasterRecoveryAuthorizationRules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceBusDisasterRecoveryResource created on azure
            // for more information of creating ServiceBusDisasterRecoveryResource, please refer to the document of ServiceBusDisasterRecoveryResource
            string subscriptionId = "exampleSubscriptionId";
            string resourceGroupName = "exampleResourceGroup";
            string namespaceName = "sdk-Namespace-9080";
            string @alias = "sdk-DisasterRecovery-4879";
            ResourceIdentifier serviceBusDisasterRecoveryResourceId = ServiceBusDisasterRecoveryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, @alias);
            ServiceBusDisasterRecoveryResource serviceBusDisasterRecovery = client.GetServiceBusDisasterRecoveryResource(serviceBusDisasterRecoveryResourceId);

            // get the collection of this ServiceBusDisasterRecoveryAuthorizationRuleResource
            ServiceBusDisasterRecoveryAuthorizationRuleCollection collection = serviceBusDisasterRecovery.GetServiceBusDisasterRecoveryAuthorizationRules();

            // invoke the operation
            string authorizationRuleName = "sdk-Authrules-4879";
            bool result = await collection.ExistsAsync(authorizationRuleName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // DisasterRecoveryConfigsAuthorizationRuleGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_DisasterRecoveryConfigsAuthorizationRuleGet()
        {
            // Generated from example definition: specification/servicebus/resource-manager/Microsoft.ServiceBus/preview/2022-10-01-preview/examples/disasterRecoveryConfigs/SBAliasAuthorizationRuleGet.json
            // this example is just showing the usage of "DisasterRecoveryAuthorizationRules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceBusDisasterRecoveryResource created on azure
            // for more information of creating ServiceBusDisasterRecoveryResource, please refer to the document of ServiceBusDisasterRecoveryResource
            string subscriptionId = "exampleSubscriptionId";
            string resourceGroupName = "exampleResourceGroup";
            string namespaceName = "sdk-Namespace-9080";
            string @alias = "sdk-DisasterRecovery-4879";
            ResourceIdentifier serviceBusDisasterRecoveryResourceId = ServiceBusDisasterRecoveryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, @alias);
            ServiceBusDisasterRecoveryResource serviceBusDisasterRecovery = client.GetServiceBusDisasterRecoveryResource(serviceBusDisasterRecoveryResourceId);

            // get the collection of this ServiceBusDisasterRecoveryAuthorizationRuleResource
            ServiceBusDisasterRecoveryAuthorizationRuleCollection collection = serviceBusDisasterRecovery.GetServiceBusDisasterRecoveryAuthorizationRules();

            // invoke the operation
            string authorizationRuleName = "sdk-Authrules-4879";
            NullableResponse<ServiceBusDisasterRecoveryAuthorizationRuleResource> response = await collection.GetIfExistsAsync(authorizationRuleName);
            ServiceBusDisasterRecoveryAuthorizationRuleResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ServiceBusAuthorizationRuleData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
