// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ServiceBus.Models;

namespace Azure.ResourceManager.ServiceBus.Samples
{
    public partial class Sample_MigrationConfigurationResource
    {
        // MigrationConfigurationsStartMigration
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_MigrationConfigurationsStartMigration()
        {
            // Generated from example definition: specification/servicebus/resource-manager/Microsoft.ServiceBus/preview/2022-10-01-preview/examples/Migrationconfigurations/SBMigrationconfigurationCreateAndStartMigration.json
            // this example is just showing the usage of "MigrationConfigs_CreateAndStartMigration" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MigrationConfigurationResource created on azure
            // for more information of creating MigrationConfigurationResource, please refer to the document of MigrationConfigurationResource
            string subscriptionId = "SubscriptionId";
            string resourceGroupName = "ResourceGroup";
            string namespaceName = "sdk-Namespace-41";
            MigrationConfigurationName configName = MigrationConfigurationName.Default;
            ResourceIdentifier migrationConfigurationResourceId = MigrationConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, configName);
            MigrationConfigurationResource migrationConfiguration = client.GetMigrationConfigurationResource(migrationConfigurationResourceId);

            // invoke the operation
            MigrationConfigurationData data = new MigrationConfigurationData()
            {
                TargetServiceBusNamespace = new ResourceIdentifier("/subscriptions/SubscriptionId/resourceGroups/ResourceGroup/providers/Microsoft.ServiceBus/namespaces/sdk-Namespace-4028"),
                PostMigrationName = "sdk-PostMigration-5919",
            };
            ArmOperation<MigrationConfigurationResource> lro = await migrationConfiguration.UpdateAsync(WaitUntil.Completed, data);
            MigrationConfigurationResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MigrationConfigurationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // MigrationConfigurationsDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_MigrationConfigurationsDelete()
        {
            // Generated from example definition: specification/servicebus/resource-manager/Microsoft.ServiceBus/preview/2022-10-01-preview/examples/Migrationconfigurations/SBMigrationconfigurationDelete.json
            // this example is just showing the usage of "MigrationConfigs_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MigrationConfigurationResource created on azure
            // for more information of creating MigrationConfigurationResource, please refer to the document of MigrationConfigurationResource
            string subscriptionId = "SubscriptionId";
            string resourceGroupName = "ResourceGroup";
            string namespaceName = "sdk-Namespace-41";
            MigrationConfigurationName configName = MigrationConfigurationName.Default;
            ResourceIdentifier migrationConfigurationResourceId = MigrationConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, configName);
            MigrationConfigurationResource migrationConfiguration = client.GetMigrationConfigurationResource(migrationConfigurationResourceId);

            // invoke the operation
            await migrationConfiguration.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // MigrationConfigurationsGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_MigrationConfigurationsGet()
        {
            // Generated from example definition: specification/servicebus/resource-manager/Microsoft.ServiceBus/preview/2022-10-01-preview/examples/Migrationconfigurations/SBMigrationconfigurationGet.json
            // this example is just showing the usage of "MigrationConfigs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MigrationConfigurationResource created on azure
            // for more information of creating MigrationConfigurationResource, please refer to the document of MigrationConfigurationResource
            string subscriptionId = "SubscriptionId";
            string resourceGroupName = "ResourceGroup";
            string namespaceName = "sdk-Namespace-41";
            MigrationConfigurationName configName = MigrationConfigurationName.Default;
            ResourceIdentifier migrationConfigurationResourceId = MigrationConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, configName);
            MigrationConfigurationResource migrationConfiguration = client.GetMigrationConfigurationResource(migrationConfigurationResourceId);

            // invoke the operation
            MigrationConfigurationResource result = await migrationConfiguration.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MigrationConfigurationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // MigrationConfigurationsCompleteMigration
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CompleteMigration_MigrationConfigurationsCompleteMigration()
        {
            // Generated from example definition: specification/servicebus/resource-manager/Microsoft.ServiceBus/preview/2022-10-01-preview/examples/Migrationconfigurations/SBMigrationconfigurationCompleteMigration.json
            // this example is just showing the usage of "MigrationConfigs_CompleteMigration" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MigrationConfigurationResource created on azure
            // for more information of creating MigrationConfigurationResource, please refer to the document of MigrationConfigurationResource
            string subscriptionId = "SubscriptionId";
            string resourceGroupName = "ResourceGroup";
            string namespaceName = "sdk-Namespace-41";
            MigrationConfigurationName configName = MigrationConfigurationName.Default;
            ResourceIdentifier migrationConfigurationResourceId = MigrationConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, configName);
            MigrationConfigurationResource migrationConfiguration = client.GetMigrationConfigurationResource(migrationConfigurationResourceId);

            // invoke the operation
            await migrationConfiguration.CompleteMigrationAsync();

            Console.WriteLine($"Succeeded");
        }

        // MigrationConfigurationsRevert
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Revert_MigrationConfigurationsRevert()
        {
            // Generated from example definition: specification/servicebus/resource-manager/Microsoft.ServiceBus/preview/2022-10-01-preview/examples/Migrationconfigurations/SBMigrationconfigurationRevert.json
            // this example is just showing the usage of "MigrationConfigs_Revert" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MigrationConfigurationResource created on azure
            // for more information of creating MigrationConfigurationResource, please refer to the document of MigrationConfigurationResource
            string subscriptionId = "SubscriptionId";
            string resourceGroupName = "ResourceGroup";
            string namespaceName = "sdk-Namespace-41";
            MigrationConfigurationName configName = MigrationConfigurationName.Default;
            ResourceIdentifier migrationConfigurationResourceId = MigrationConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, configName);
            MigrationConfigurationResource migrationConfiguration = client.GetMigrationConfigurationResource(migrationConfigurationResourceId);

            // invoke the operation
            await migrationConfiguration.RevertAsync();

            Console.WriteLine($"Succeeded");
        }
    }
}
