// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.SelfHelp.Models;

namespace Azure.ResourceManager.SelfHelp
{
    /// <summary>
    /// A Class representing a SelfHelpTroubleshooter along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="SelfHelpTroubleshooterResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetSelfHelpTroubleshooterResource method.
    /// Otherwise you can get one from its parent resource <see cref="ArmResource"/> using the GetSelfHelpTroubleshooter method.
    /// </summary>
    public partial class SelfHelpTroubleshooterResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="SelfHelpTroubleshooterResource"/> instance. </summary>
        /// <param name="scope"> The scope. </param>
        /// <param name="troubleshooterName"> The troubleshooterName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string scope, string troubleshooterName)
        {
            var resourceId = $"{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _selfHelpTroubleshooterTroubleshootersClientDiagnostics;
        private readonly TroubleshootersRestOperations _selfHelpTroubleshooterTroubleshootersRestClient;
        private readonly SelfHelpTroubleshooterData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Help/troubleshooters";

        /// <summary> Initializes a new instance of the <see cref="SelfHelpTroubleshooterResource"/> class for mocking. </summary>
        protected SelfHelpTroubleshooterResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SelfHelpTroubleshooterResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal SelfHelpTroubleshooterResource(ArmClient client, SelfHelpTroubleshooterData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="SelfHelpTroubleshooterResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal SelfHelpTroubleshooterResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _selfHelpTroubleshooterTroubleshootersClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SelfHelp", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string selfHelpTroubleshooterTroubleshootersApiVersion);
            _selfHelpTroubleshooterTroubleshootersRestClient = new TroubleshootersRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, selfHelpTroubleshooterTroubleshootersApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual SelfHelpTroubleshooterData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets troubleshooter instance result which includes the step status/result of the troubleshooter resource name that is being executed.&lt;br/&gt; Get API is used to retrieve the result of a Troubleshooter instance, which includes the status and result of each step in the Troubleshooter workflow. This API requires the Troubleshooter resource name that was created using the Create API.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Troubleshooters_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpTroubleshooterResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SelfHelpTroubleshooterResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _selfHelpTroubleshooterTroubleshootersClientDiagnostics.CreateScope("SelfHelpTroubleshooterResource.Get");
            scope.Start();
            try
            {
                var response = await _selfHelpTroubleshooterTroubleshootersRestClient.GetAsync(Id.Parent, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SelfHelpTroubleshooterResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets troubleshooter instance result which includes the step status/result of the troubleshooter resource name that is being executed.&lt;br/&gt; Get API is used to retrieve the result of a Troubleshooter instance, which includes the status and result of each step in the Troubleshooter workflow. This API requires the Troubleshooter resource name that was created using the Create API.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Troubleshooters_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpTroubleshooterResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SelfHelpTroubleshooterResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _selfHelpTroubleshooterTroubleshootersClientDiagnostics.CreateScope("SelfHelpTroubleshooterResource.Get");
            scope.Start();
            try
            {
                var response = _selfHelpTroubleshooterTroubleshootersRestClient.Get(Id.Parent, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SelfHelpTroubleshooterResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates the specific troubleshooter action under a resource or subscription using the ‘solutionId’ and  ‘properties.parameters’ as the trigger. &lt;br/&gt; Azure Troubleshooters help with hard to classify issues, reducing the gap between customer observed problems and solutions by guiding the user effortlessly through the troubleshooting process. Each Troubleshooter flow represents a problem area within Azure and has a complex tree-like structure that addresses many root causes. These flows are prepared with the help of Subject Matter experts and customer support engineers by carefully considering previous support requests raised by customers. Troubleshooters terminate at a well curated solution based off of resource backend signals and customer manual selections.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Troubleshooters_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpTroubleshooterResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> The required request body for this Troubleshooter resource creation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SelfHelpTroubleshooterResource>> UpdateAsync(WaitUntil waitUntil, SelfHelpTroubleshooterData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _selfHelpTroubleshooterTroubleshootersClientDiagnostics.CreateScope("SelfHelpTroubleshooterResource.Update");
            scope.Start();
            try
            {
                var response = await _selfHelpTroubleshooterTroubleshootersRestClient.CreateAsync(Id.Parent, Id.Name, data, cancellationToken).ConfigureAwait(false);
                var uri = _selfHelpTroubleshooterTroubleshootersRestClient.CreateCreateRequestUri(Id.Parent, Id.Name, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SelfHelpArmOperation<SelfHelpTroubleshooterResource>(Response.FromValue(new SelfHelpTroubleshooterResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates the specific troubleshooter action under a resource or subscription using the ‘solutionId’ and  ‘properties.parameters’ as the trigger. &lt;br/&gt; Azure Troubleshooters help with hard to classify issues, reducing the gap between customer observed problems and solutions by guiding the user effortlessly through the troubleshooting process. Each Troubleshooter flow represents a problem area within Azure and has a complex tree-like structure that addresses many root causes. These flows are prepared with the help of Subject Matter experts and customer support engineers by carefully considering previous support requests raised by customers. Troubleshooters terminate at a well curated solution based off of resource backend signals and customer manual selections.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Troubleshooters_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpTroubleshooterResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> The required request body for this Troubleshooter resource creation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SelfHelpTroubleshooterResource> Update(WaitUntil waitUntil, SelfHelpTroubleshooterData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _selfHelpTroubleshooterTroubleshootersClientDiagnostics.CreateScope("SelfHelpTroubleshooterResource.Update");
            scope.Start();
            try
            {
                var response = _selfHelpTroubleshooterTroubleshootersRestClient.Create(Id.Parent, Id.Name, data, cancellationToken);
                var uri = _selfHelpTroubleshooterTroubleshootersRestClient.CreateCreateRequestUri(Id.Parent, Id.Name, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SelfHelpArmOperation<SelfHelpTroubleshooterResource>(Response.FromValue(new SelfHelpTroubleshooterResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Uses ‘stepId’ and ‘responses’ as the trigger to continue the troubleshooting steps for the respective troubleshooter resource name. &lt;br/&gt;Continue API is used to provide inputs that are required for the specific troubleshooter to progress into the next step in the process. This API is used after the Troubleshooter has been created using the Create API.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}/continue</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Troubleshooters_Continue</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpTroubleshooterResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The required request body for going to next step in Troubleshooter resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response> ContinueAsync(TroubleshooterContinueContent content = null, CancellationToken cancellationToken = default)
        {
            using var scope = _selfHelpTroubleshooterTroubleshootersClientDiagnostics.CreateScope("SelfHelpTroubleshooterResource.Continue");
            scope.Start();
            try
            {
                var response = await _selfHelpTroubleshooterTroubleshootersRestClient.ContinueAsync(Id.Parent, Id.Name, content, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Uses ‘stepId’ and ‘responses’ as the trigger to continue the troubleshooting steps for the respective troubleshooter resource name. &lt;br/&gt;Continue API is used to provide inputs that are required for the specific troubleshooter to progress into the next step in the process. This API is used after the Troubleshooter has been created using the Create API.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}/continue</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Troubleshooters_Continue</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpTroubleshooterResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The required request body for going to next step in Troubleshooter resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response Continue(TroubleshooterContinueContent content = null, CancellationToken cancellationToken = default)
        {
            using var scope = _selfHelpTroubleshooterTroubleshootersClientDiagnostics.CreateScope("SelfHelpTroubleshooterResource.Continue");
            scope.Start();
            try
            {
                var response = _selfHelpTroubleshooterTroubleshootersRestClient.Continue(Id.Parent, Id.Name, content, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Ends the troubleshooter action
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}/end</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Troubleshooters_End</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpTroubleshooterResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response> EndAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _selfHelpTroubleshooterTroubleshootersClientDiagnostics.CreateScope("SelfHelpTroubleshooterResource.End");
            scope.Start();
            try
            {
                var response = await _selfHelpTroubleshooterTroubleshootersRestClient.EndAsync(Id.Parent, Id.Name, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Ends the troubleshooter action
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}/end</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Troubleshooters_End</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpTroubleshooterResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response End(CancellationToken cancellationToken = default)
        {
            using var scope = _selfHelpTroubleshooterTroubleshootersClientDiagnostics.CreateScope("SelfHelpTroubleshooterResource.End");
            scope.Start();
            try
            {
                var response = _selfHelpTroubleshooterTroubleshootersRestClient.End(Id.Parent, Id.Name, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Restarts the troubleshooter API using applicable troubleshooter resource name as the input.&lt;br/&gt; It returns new resource name which should be used in subsequent request. The old resource name is obsolete after this API is invoked.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}/restart</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Troubleshooters_Restart</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpTroubleshooterResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<RestartTroubleshooterResult>> RestartAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _selfHelpTroubleshooterTroubleshootersClientDiagnostics.CreateScope("SelfHelpTroubleshooterResource.Restart");
            scope.Start();
            try
            {
                var response = await _selfHelpTroubleshooterTroubleshootersRestClient.RestartAsync(Id.Parent, Id.Name, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Restarts the troubleshooter API using applicable troubleshooter resource name as the input.&lt;br/&gt; It returns new resource name which should be used in subsequent request. The old resource name is obsolete after this API is invoked.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}/restart</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Troubleshooters_Restart</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpTroubleshooterResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<RestartTroubleshooterResult> Restart(CancellationToken cancellationToken = default)
        {
            using var scope = _selfHelpTroubleshooterTroubleshootersClientDiagnostics.CreateScope("SelfHelpTroubleshooterResource.Restart");
            scope.Start();
            try
            {
                var response = _selfHelpTroubleshooterTroubleshootersRestClient.Restart(Id.Parent, Id.Name, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
