// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SelfHelp.Models;

namespace Azure.ResourceManager.SelfHelp
{
    /// <summary>
    /// A class representing the SelfHelpTroubleshooter data model.
    /// Troubleshooter response.
    /// </summary>
    public partial class SelfHelpTroubleshooterData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SelfHelpTroubleshooterData"/>. </summary>
        public SelfHelpTroubleshooterData()
        {
            Parameters = new ChangeTrackingDictionary<string, string>();
            Steps = new ChangeTrackingList<SelfHelpStep>();
        }

        /// <summary> Initializes a new instance of <see cref="SelfHelpTroubleshooterData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="solutionId"> Solution Id to identify single troubleshooter. </param>
        /// <param name="parameters"> Client input parameters to run Troubleshooter Resource. </param>
        /// <param name="provisioningState"> Status of troubleshooter provisioning. </param>
        /// <param name="steps"> List of step object. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SelfHelpTroubleshooterData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string solutionId, IDictionary<string, string> parameters, TroubleshooterProvisioningState? provisioningState, IReadOnlyList<SelfHelpStep> steps, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            SolutionId = solutionId;
            Parameters = parameters;
            ProvisioningState = provisioningState;
            Steps = steps;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Solution Id to identify single troubleshooter. </summary>
        public string SolutionId { get; set; }
        /// <summary> Client input parameters to run Troubleshooter Resource. </summary>
        public IDictionary<string, string> Parameters { get; }
        /// <summary> Status of troubleshooter provisioning. </summary>
        public TroubleshooterProvisioningState? ProvisioningState { get; }
        /// <summary> List of step object. </summary>
        public IReadOnlyList<SelfHelpStep> Steps { get; }
    }
}
