// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SelfHelp
{
    /// <summary>
    /// A class representing a collection of <see cref="SelfHelpTroubleshooterResource"/> and their operations.
    /// Each <see cref="SelfHelpTroubleshooterResource"/> in the collection will belong to the same instance of <see cref="ArmResource"/>.
    /// To get a <see cref="SelfHelpTroubleshooterCollection"/> instance call the GetSelfHelpTroubleshooters method from an instance of <see cref="ArmResource"/>.
    /// </summary>
    public partial class SelfHelpTroubleshooterCollection : ArmCollection
    {
        private readonly ClientDiagnostics _selfHelpTroubleshooterTroubleshootersClientDiagnostics;
        private readonly TroubleshootersRestOperations _selfHelpTroubleshooterTroubleshootersRestClient;

        /// <summary> Initializes a new instance of the <see cref="SelfHelpTroubleshooterCollection"/> class for mocking. </summary>
        protected SelfHelpTroubleshooterCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SelfHelpTroubleshooterCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SelfHelpTroubleshooterCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _selfHelpTroubleshooterTroubleshootersClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SelfHelp", SelfHelpTroubleshooterResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SelfHelpTroubleshooterResource.ResourceType, out string selfHelpTroubleshooterTroubleshootersApiVersion);
            _selfHelpTroubleshooterTroubleshootersRestClient = new TroubleshootersRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, selfHelpTroubleshooterTroubleshootersApiVersion);
        }

        /// <summary>
        /// Creates the specific troubleshooter action under a resource or subscription using the ‘solutionId’ and  ‘properties.parameters’ as the trigger. &lt;br/&gt; Azure Troubleshooters help with hard to classify issues, reducing the gap between customer observed problems and solutions by guiding the user effortlessly through the troubleshooting process. Each Troubleshooter flow represents a problem area within Azure and has a complex tree-like structure that addresses many root causes. These flows are prepared with the help of Subject Matter experts and customer support engineers by carefully considering previous support requests raised by customers. Troubleshooters terminate at a well curated solution based off of resource backend signals and customer manual selections.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Troubleshooters_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpTroubleshooterResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="troubleshooterName"> Troubleshooter resource Name. </param>
        /// <param name="data"> The required request body for this Troubleshooter resource creation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="troubleshooterName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="troubleshooterName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SelfHelpTroubleshooterResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string troubleshooterName, SelfHelpTroubleshooterData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(troubleshooterName, nameof(troubleshooterName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _selfHelpTroubleshooterTroubleshootersClientDiagnostics.CreateScope("SelfHelpTroubleshooterCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _selfHelpTroubleshooterTroubleshootersRestClient.CreateAsync(Id, troubleshooterName, data, cancellationToken).ConfigureAwait(false);
                var uri = _selfHelpTroubleshooterTroubleshootersRestClient.CreateCreateRequestUri(Id, troubleshooterName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SelfHelpArmOperation<SelfHelpTroubleshooterResource>(Response.FromValue(new SelfHelpTroubleshooterResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates the specific troubleshooter action under a resource or subscription using the ‘solutionId’ and  ‘properties.parameters’ as the trigger. &lt;br/&gt; Azure Troubleshooters help with hard to classify issues, reducing the gap between customer observed problems and solutions by guiding the user effortlessly through the troubleshooting process. Each Troubleshooter flow represents a problem area within Azure and has a complex tree-like structure that addresses many root causes. These flows are prepared with the help of Subject Matter experts and customer support engineers by carefully considering previous support requests raised by customers. Troubleshooters terminate at a well curated solution based off of resource backend signals and customer manual selections.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Troubleshooters_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpTroubleshooterResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="troubleshooterName"> Troubleshooter resource Name. </param>
        /// <param name="data"> The required request body for this Troubleshooter resource creation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="troubleshooterName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="troubleshooterName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SelfHelpTroubleshooterResource> CreateOrUpdate(WaitUntil waitUntil, string troubleshooterName, SelfHelpTroubleshooterData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(troubleshooterName, nameof(troubleshooterName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _selfHelpTroubleshooterTroubleshootersClientDiagnostics.CreateScope("SelfHelpTroubleshooterCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _selfHelpTroubleshooterTroubleshootersRestClient.Create(Id, troubleshooterName, data, cancellationToken);
                var uri = _selfHelpTroubleshooterTroubleshootersRestClient.CreateCreateRequestUri(Id, troubleshooterName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SelfHelpArmOperation<SelfHelpTroubleshooterResource>(Response.FromValue(new SelfHelpTroubleshooterResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets troubleshooter instance result which includes the step status/result of the troubleshooter resource name that is being executed.&lt;br/&gt; Get API is used to retrieve the result of a Troubleshooter instance, which includes the status and result of each step in the Troubleshooter workflow. This API requires the Troubleshooter resource name that was created using the Create API.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Troubleshooters_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpTroubleshooterResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="troubleshooterName"> Troubleshooter resource Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="troubleshooterName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="troubleshooterName"/> is null. </exception>
        public virtual async Task<Response<SelfHelpTroubleshooterResource>> GetAsync(string troubleshooterName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(troubleshooterName, nameof(troubleshooterName));

            using var scope = _selfHelpTroubleshooterTroubleshootersClientDiagnostics.CreateScope("SelfHelpTroubleshooterCollection.Get");
            scope.Start();
            try
            {
                var response = await _selfHelpTroubleshooterTroubleshootersRestClient.GetAsync(Id, troubleshooterName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SelfHelpTroubleshooterResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets troubleshooter instance result which includes the step status/result of the troubleshooter resource name that is being executed.&lt;br/&gt; Get API is used to retrieve the result of a Troubleshooter instance, which includes the status and result of each step in the Troubleshooter workflow. This API requires the Troubleshooter resource name that was created using the Create API.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Troubleshooters_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpTroubleshooterResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="troubleshooterName"> Troubleshooter resource Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="troubleshooterName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="troubleshooterName"/> is null. </exception>
        public virtual Response<SelfHelpTroubleshooterResource> Get(string troubleshooterName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(troubleshooterName, nameof(troubleshooterName));

            using var scope = _selfHelpTroubleshooterTroubleshootersClientDiagnostics.CreateScope("SelfHelpTroubleshooterCollection.Get");
            scope.Start();
            try
            {
                var response = _selfHelpTroubleshooterTroubleshootersRestClient.Get(Id, troubleshooterName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SelfHelpTroubleshooterResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Troubleshooters_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpTroubleshooterResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="troubleshooterName"> Troubleshooter resource Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="troubleshooterName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="troubleshooterName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string troubleshooterName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(troubleshooterName, nameof(troubleshooterName));

            using var scope = _selfHelpTroubleshooterTroubleshootersClientDiagnostics.CreateScope("SelfHelpTroubleshooterCollection.Exists");
            scope.Start();
            try
            {
                var response = await _selfHelpTroubleshooterTroubleshootersRestClient.GetAsync(Id, troubleshooterName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Troubleshooters_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpTroubleshooterResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="troubleshooterName"> Troubleshooter resource Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="troubleshooterName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="troubleshooterName"/> is null. </exception>
        public virtual Response<bool> Exists(string troubleshooterName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(troubleshooterName, nameof(troubleshooterName));

            using var scope = _selfHelpTroubleshooterTroubleshootersClientDiagnostics.CreateScope("SelfHelpTroubleshooterCollection.Exists");
            scope.Start();
            try
            {
                var response = _selfHelpTroubleshooterTroubleshootersRestClient.Get(Id, troubleshooterName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Troubleshooters_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpTroubleshooterResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="troubleshooterName"> Troubleshooter resource Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="troubleshooterName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="troubleshooterName"/> is null. </exception>
        public virtual async Task<NullableResponse<SelfHelpTroubleshooterResource>> GetIfExistsAsync(string troubleshooterName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(troubleshooterName, nameof(troubleshooterName));

            using var scope = _selfHelpTroubleshooterTroubleshootersClientDiagnostics.CreateScope("SelfHelpTroubleshooterCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _selfHelpTroubleshooterTroubleshootersRestClient.GetAsync(Id, troubleshooterName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SelfHelpTroubleshooterResource>(response.GetRawResponse());
                return Response.FromValue(new SelfHelpTroubleshooterResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Troubleshooters_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpTroubleshooterResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="troubleshooterName"> Troubleshooter resource Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="troubleshooterName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="troubleshooterName"/> is null. </exception>
        public virtual NullableResponse<SelfHelpTroubleshooterResource> GetIfExists(string troubleshooterName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(troubleshooterName, nameof(troubleshooterName));

            using var scope = _selfHelpTroubleshooterTroubleshootersClientDiagnostics.CreateScope("SelfHelpTroubleshooterCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _selfHelpTroubleshooterTroubleshootersRestClient.Get(Id, troubleshooterName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SelfHelpTroubleshooterResource>(response.GetRawResponse());
                return Response.FromValue(new SelfHelpTroubleshooterResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
