// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SelfHelp
{
    /// <summary>
    /// A class representing a collection of <see cref="SelfHelpSolutionResource"/> and their operations.
    /// Each <see cref="SelfHelpSolutionResource"/> in the collection will belong to the same instance of <see cref="ArmResource"/>.
    /// To get a <see cref="SelfHelpSolutionCollection"/> instance call the GetSelfHelpSolutions method from an instance of <see cref="ArmResource"/>.
    /// </summary>
    public partial class SelfHelpSolutionCollection : ArmCollection
    {
        private readonly ClientDiagnostics _selfHelpSolutionSolutionClientDiagnostics;
        private readonly SolutionRestOperations _selfHelpSolutionSolutionRestClient;

        /// <summary> Initializes a new instance of the <see cref="SelfHelpSolutionCollection"/> class for mocking. </summary>
        protected SelfHelpSolutionCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SelfHelpSolutionCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SelfHelpSolutionCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _selfHelpSolutionSolutionClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SelfHelp", SelfHelpSolutionResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SelfHelpSolutionResource.ResourceType, out string selfHelpSolutionSolutionApiVersion);
            _selfHelpSolutionSolutionRestClient = new SolutionRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, selfHelpSolutionSolutionApiVersion);
        }

        /// <summary>
        /// Creates a solution for the specific Azure resource or subscription using the inputs ‘solutionId and requiredInputs’ from discovery solutions. &lt;br/&gt; Azure solutions comprise a comprehensive library of self-help resources that have been thoughtfully curated by Azure engineers to aid customers in resolving typical troubleshooting issues. These solutions encompass: &lt;br/&gt; (1.) Dynamic and context-aware diagnostics, guided troubleshooting wizards, and data visualizations. &lt;br/&gt; (2.) Rich instructional video tutorials and illustrative diagrams and images. &lt;br/&gt; (3.) Thoughtfully assembled textual troubleshooting instructions. &lt;br/&gt; All these components are seamlessly converged into unified solutions tailored to address a specific support problem area.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/solutions/{solutionResourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Solution_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpSolutionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="solutionResourceName"> Solution resource Name. </param>
        /// <param name="data"> The required request body for this solution resource creation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="solutionResourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="solutionResourceName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SelfHelpSolutionResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string solutionResourceName, SelfHelpSolutionData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(solutionResourceName, nameof(solutionResourceName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _selfHelpSolutionSolutionClientDiagnostics.CreateScope("SelfHelpSolutionCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _selfHelpSolutionSolutionRestClient.CreateAsync(Id, solutionResourceName, data, cancellationToken).ConfigureAwait(false);
                var operation = new SelfHelpArmOperation<SelfHelpSolutionResource>(new SelfHelpSolutionOperationSource(Client), _selfHelpSolutionSolutionClientDiagnostics, Pipeline, _selfHelpSolutionSolutionRestClient.CreateCreateRequest(Id, solutionResourceName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates a solution for the specific Azure resource or subscription using the inputs ‘solutionId and requiredInputs’ from discovery solutions. &lt;br/&gt; Azure solutions comprise a comprehensive library of self-help resources that have been thoughtfully curated by Azure engineers to aid customers in resolving typical troubleshooting issues. These solutions encompass: &lt;br/&gt; (1.) Dynamic and context-aware diagnostics, guided troubleshooting wizards, and data visualizations. &lt;br/&gt; (2.) Rich instructional video tutorials and illustrative diagrams and images. &lt;br/&gt; (3.) Thoughtfully assembled textual troubleshooting instructions. &lt;br/&gt; All these components are seamlessly converged into unified solutions tailored to address a specific support problem area.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/solutions/{solutionResourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Solution_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpSolutionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="solutionResourceName"> Solution resource Name. </param>
        /// <param name="data"> The required request body for this solution resource creation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="solutionResourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="solutionResourceName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SelfHelpSolutionResource> CreateOrUpdate(WaitUntil waitUntil, string solutionResourceName, SelfHelpSolutionData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(solutionResourceName, nameof(solutionResourceName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _selfHelpSolutionSolutionClientDiagnostics.CreateScope("SelfHelpSolutionCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _selfHelpSolutionSolutionRestClient.Create(Id, solutionResourceName, data, cancellationToken);
                var operation = new SelfHelpArmOperation<SelfHelpSolutionResource>(new SelfHelpSolutionOperationSource(Client), _selfHelpSolutionSolutionClientDiagnostics, Pipeline, _selfHelpSolutionSolutionRestClient.CreateCreateRequest(Id, solutionResourceName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the solution using the applicable solutionResourceName while creating the solution.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/solutions/{solutionResourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Solution_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpSolutionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="solutionResourceName"> Solution resource Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="solutionResourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="solutionResourceName"/> is null. </exception>
        public virtual async Task<Response<SelfHelpSolutionResource>> GetAsync(string solutionResourceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(solutionResourceName, nameof(solutionResourceName));

            using var scope = _selfHelpSolutionSolutionClientDiagnostics.CreateScope("SelfHelpSolutionCollection.Get");
            scope.Start();
            try
            {
                var response = await _selfHelpSolutionSolutionRestClient.GetAsync(Id, solutionResourceName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SelfHelpSolutionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the solution using the applicable solutionResourceName while creating the solution.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/solutions/{solutionResourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Solution_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpSolutionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="solutionResourceName"> Solution resource Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="solutionResourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="solutionResourceName"/> is null. </exception>
        public virtual Response<SelfHelpSolutionResource> Get(string solutionResourceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(solutionResourceName, nameof(solutionResourceName));

            using var scope = _selfHelpSolutionSolutionClientDiagnostics.CreateScope("SelfHelpSolutionCollection.Get");
            scope.Start();
            try
            {
                var response = _selfHelpSolutionSolutionRestClient.Get(Id, solutionResourceName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SelfHelpSolutionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/solutions/{solutionResourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Solution_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpSolutionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="solutionResourceName"> Solution resource Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="solutionResourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="solutionResourceName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string solutionResourceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(solutionResourceName, nameof(solutionResourceName));

            using var scope = _selfHelpSolutionSolutionClientDiagnostics.CreateScope("SelfHelpSolutionCollection.Exists");
            scope.Start();
            try
            {
                var response = await _selfHelpSolutionSolutionRestClient.GetAsync(Id, solutionResourceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/solutions/{solutionResourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Solution_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpSolutionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="solutionResourceName"> Solution resource Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="solutionResourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="solutionResourceName"/> is null. </exception>
        public virtual Response<bool> Exists(string solutionResourceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(solutionResourceName, nameof(solutionResourceName));

            using var scope = _selfHelpSolutionSolutionClientDiagnostics.CreateScope("SelfHelpSolutionCollection.Exists");
            scope.Start();
            try
            {
                var response = _selfHelpSolutionSolutionRestClient.Get(Id, solutionResourceName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/solutions/{solutionResourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Solution_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpSolutionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="solutionResourceName"> Solution resource Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="solutionResourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="solutionResourceName"/> is null. </exception>
        public virtual async Task<NullableResponse<SelfHelpSolutionResource>> GetIfExistsAsync(string solutionResourceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(solutionResourceName, nameof(solutionResourceName));

            using var scope = _selfHelpSolutionSolutionClientDiagnostics.CreateScope("SelfHelpSolutionCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _selfHelpSolutionSolutionRestClient.GetAsync(Id, solutionResourceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SelfHelpSolutionResource>(response.GetRawResponse());
                return Response.FromValue(new SelfHelpSolutionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/solutions/{solutionResourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Solution_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpSolutionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="solutionResourceName"> Solution resource Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="solutionResourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="solutionResourceName"/> is null. </exception>
        public virtual NullableResponse<SelfHelpSolutionResource> GetIfExists(string solutionResourceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(solutionResourceName, nameof(solutionResourceName));

            using var scope = _selfHelpSolutionSolutionClientDiagnostics.CreateScope("SelfHelpSolutionCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _selfHelpSolutionSolutionRestClient.Get(Id, solutionResourceName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SelfHelpSolutionResource>(response.GetRawResponse());
                return Response.FromValue(new SelfHelpSolutionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
