// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SelfHelp.Models;

namespace Azure.ResourceManager.SelfHelp
{
    /// <summary>
    /// A class representing the SelfHelpSimplifiedSolution data model.
    /// Simplified Solutions response.
    /// </summary>
    public partial class SelfHelpSimplifiedSolutionData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SelfHelpSimplifiedSolutionData"/>. </summary>
        public SelfHelpSimplifiedSolutionData()
        {
            Parameters = new ChangeTrackingDictionary<string, string>();
            Appendix = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="SelfHelpSimplifiedSolutionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="solutionId"> Solution Id to identify single Simplified Solution. </param>
        /// <param name="parameters"> Client input parameters to run Simplified Solutions. </param>
        /// <param name="title"> The title. </param>
        /// <param name="appendix"> Additional parameter response for Simplified Solutions. </param>
        /// <param name="content"> The HTML content that needs to be rendered and shown to customer. </param>
        /// <param name="provisioningState"> Status of Simplified Solution provisioning. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SelfHelpSimplifiedSolutionData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string solutionId, IDictionary<string, string> parameters, string title, IReadOnlyDictionary<string, string> appendix, string content, SolutionProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            SolutionId = solutionId;
            Parameters = parameters;
            Title = title;
            Appendix = appendix;
            Content = content;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Solution Id to identify single Simplified Solution. </summary>
        public string SolutionId { get; set; }
        /// <summary> Client input parameters to run Simplified Solutions. </summary>
        public IDictionary<string, string> Parameters { get; }
        /// <summary> The title. </summary>
        public string Title { get; }
        /// <summary> Additional parameter response for Simplified Solutions. </summary>
        public IReadOnlyDictionary<string, string> Appendix { get; }
        /// <summary> The HTML content that needs to be rendered and shown to customer. </summary>
        public string Content { get; }
        /// <summary> Status of Simplified Solution provisioning. </summary>
        public SolutionProvisioningState? ProvisioningState { get; }
    }
}
