// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SelfHelp
{
    /// <summary>
    /// A class representing a collection of <see cref="SelfHelpSimplifiedSolutionResource"/> and their operations.
    /// Each <see cref="SelfHelpSimplifiedSolutionResource"/> in the collection will belong to the same instance of <see cref="ArmResource"/>.
    /// To get a <see cref="SelfHelpSimplifiedSolutionCollection"/> instance call the GetSelfHelpSimplifiedSolutions method from an instance of <see cref="ArmResource"/>.
    /// </summary>
    public partial class SelfHelpSimplifiedSolutionCollection : ArmCollection
    {
        private readonly ClientDiagnostics _selfHelpSimplifiedSolutionSimplifiedSolutionsClientDiagnostics;
        private readonly SimplifiedSolutionsRestOperations _selfHelpSimplifiedSolutionSimplifiedSolutionsRestClient;

        /// <summary> Initializes a new instance of the <see cref="SelfHelpSimplifiedSolutionCollection"/> class for mocking. </summary>
        protected SelfHelpSimplifiedSolutionCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SelfHelpSimplifiedSolutionCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SelfHelpSimplifiedSolutionCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _selfHelpSimplifiedSolutionSimplifiedSolutionsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SelfHelp", SelfHelpSimplifiedSolutionResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SelfHelpSimplifiedSolutionResource.ResourceType, out string selfHelpSimplifiedSolutionSimplifiedSolutionsApiVersion);
            _selfHelpSimplifiedSolutionSimplifiedSolutionsRestClient = new SimplifiedSolutionsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, selfHelpSimplifiedSolutionSimplifiedSolutionsApiVersion);
        }

        /// <summary>
        /// Creates Simplified Solutions for an Azure subscription using 'solutionId' from Discovery Solutions as the input. &lt;br/&gt;&lt;br/&gt; Simplified Solutions API makes the consumption of solutions APIs easier while still providing access to the same powerful solutions rendered in Solutions API. With Simplified Solutions, users don't have to worry about stitching together the article using replacement maps and can use the content in the API response to directly render as HTML content.&lt;br/&gt;
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/simplifiedSolutions/{simplifiedSolutionsResourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SimplifiedSolutions_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpSimplifiedSolutionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="simplifiedSolutionsResourceName"> Simplified Solutions Resource Name. </param>
        /// <param name="data"> The required request body for simplified Solutions resource creation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="simplifiedSolutionsResourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="simplifiedSolutionsResourceName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SelfHelpSimplifiedSolutionResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string simplifiedSolutionsResourceName, SelfHelpSimplifiedSolutionData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(simplifiedSolutionsResourceName, nameof(simplifiedSolutionsResourceName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _selfHelpSimplifiedSolutionSimplifiedSolutionsClientDiagnostics.CreateScope("SelfHelpSimplifiedSolutionCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _selfHelpSimplifiedSolutionSimplifiedSolutionsRestClient.CreateAsync(Id, simplifiedSolutionsResourceName, data, cancellationToken).ConfigureAwait(false);
                var operation = new SelfHelpArmOperation<SelfHelpSimplifiedSolutionResource>(new SelfHelpSimplifiedSolutionOperationSource(Client), _selfHelpSimplifiedSolutionSimplifiedSolutionsClientDiagnostics, Pipeline, _selfHelpSimplifiedSolutionSimplifiedSolutionsRestClient.CreateCreateRequest(Id, simplifiedSolutionsResourceName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates Simplified Solutions for an Azure subscription using 'solutionId' from Discovery Solutions as the input. &lt;br/&gt;&lt;br/&gt; Simplified Solutions API makes the consumption of solutions APIs easier while still providing access to the same powerful solutions rendered in Solutions API. With Simplified Solutions, users don't have to worry about stitching together the article using replacement maps and can use the content in the API response to directly render as HTML content.&lt;br/&gt;
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/simplifiedSolutions/{simplifiedSolutionsResourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SimplifiedSolutions_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpSimplifiedSolutionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="simplifiedSolutionsResourceName"> Simplified Solutions Resource Name. </param>
        /// <param name="data"> The required request body for simplified Solutions resource creation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="simplifiedSolutionsResourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="simplifiedSolutionsResourceName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SelfHelpSimplifiedSolutionResource> CreateOrUpdate(WaitUntil waitUntil, string simplifiedSolutionsResourceName, SelfHelpSimplifiedSolutionData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(simplifiedSolutionsResourceName, nameof(simplifiedSolutionsResourceName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _selfHelpSimplifiedSolutionSimplifiedSolutionsClientDiagnostics.CreateScope("SelfHelpSimplifiedSolutionCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _selfHelpSimplifiedSolutionSimplifiedSolutionsRestClient.Create(Id, simplifiedSolutionsResourceName, data, cancellationToken);
                var operation = new SelfHelpArmOperation<SelfHelpSimplifiedSolutionResource>(new SelfHelpSimplifiedSolutionOperationSource(Client), _selfHelpSimplifiedSolutionSimplifiedSolutionsClientDiagnostics, Pipeline, _selfHelpSimplifiedSolutionSimplifiedSolutionsRestClient.CreateCreateRequest(Id, simplifiedSolutionsResourceName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the simplified Solutions using the applicable solutionResourceName while creating the simplified Solutions.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/simplifiedSolutions/{simplifiedSolutionsResourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SimplifiedSolutions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpSimplifiedSolutionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="simplifiedSolutionsResourceName"> Simplified Solutions Resource Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="simplifiedSolutionsResourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="simplifiedSolutionsResourceName"/> is null. </exception>
        public virtual async Task<Response<SelfHelpSimplifiedSolutionResource>> GetAsync(string simplifiedSolutionsResourceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(simplifiedSolutionsResourceName, nameof(simplifiedSolutionsResourceName));

            using var scope = _selfHelpSimplifiedSolutionSimplifiedSolutionsClientDiagnostics.CreateScope("SelfHelpSimplifiedSolutionCollection.Get");
            scope.Start();
            try
            {
                var response = await _selfHelpSimplifiedSolutionSimplifiedSolutionsRestClient.GetAsync(Id, simplifiedSolutionsResourceName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SelfHelpSimplifiedSolutionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the simplified Solutions using the applicable solutionResourceName while creating the simplified Solutions.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/simplifiedSolutions/{simplifiedSolutionsResourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SimplifiedSolutions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpSimplifiedSolutionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="simplifiedSolutionsResourceName"> Simplified Solutions Resource Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="simplifiedSolutionsResourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="simplifiedSolutionsResourceName"/> is null. </exception>
        public virtual Response<SelfHelpSimplifiedSolutionResource> Get(string simplifiedSolutionsResourceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(simplifiedSolutionsResourceName, nameof(simplifiedSolutionsResourceName));

            using var scope = _selfHelpSimplifiedSolutionSimplifiedSolutionsClientDiagnostics.CreateScope("SelfHelpSimplifiedSolutionCollection.Get");
            scope.Start();
            try
            {
                var response = _selfHelpSimplifiedSolutionSimplifiedSolutionsRestClient.Get(Id, simplifiedSolutionsResourceName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SelfHelpSimplifiedSolutionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/simplifiedSolutions/{simplifiedSolutionsResourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SimplifiedSolutions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpSimplifiedSolutionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="simplifiedSolutionsResourceName"> Simplified Solutions Resource Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="simplifiedSolutionsResourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="simplifiedSolutionsResourceName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string simplifiedSolutionsResourceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(simplifiedSolutionsResourceName, nameof(simplifiedSolutionsResourceName));

            using var scope = _selfHelpSimplifiedSolutionSimplifiedSolutionsClientDiagnostics.CreateScope("SelfHelpSimplifiedSolutionCollection.Exists");
            scope.Start();
            try
            {
                var response = await _selfHelpSimplifiedSolutionSimplifiedSolutionsRestClient.GetAsync(Id, simplifiedSolutionsResourceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/simplifiedSolutions/{simplifiedSolutionsResourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SimplifiedSolutions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpSimplifiedSolutionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="simplifiedSolutionsResourceName"> Simplified Solutions Resource Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="simplifiedSolutionsResourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="simplifiedSolutionsResourceName"/> is null. </exception>
        public virtual Response<bool> Exists(string simplifiedSolutionsResourceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(simplifiedSolutionsResourceName, nameof(simplifiedSolutionsResourceName));

            using var scope = _selfHelpSimplifiedSolutionSimplifiedSolutionsClientDiagnostics.CreateScope("SelfHelpSimplifiedSolutionCollection.Exists");
            scope.Start();
            try
            {
                var response = _selfHelpSimplifiedSolutionSimplifiedSolutionsRestClient.Get(Id, simplifiedSolutionsResourceName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/simplifiedSolutions/{simplifiedSolutionsResourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SimplifiedSolutions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpSimplifiedSolutionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="simplifiedSolutionsResourceName"> Simplified Solutions Resource Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="simplifiedSolutionsResourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="simplifiedSolutionsResourceName"/> is null. </exception>
        public virtual async Task<NullableResponse<SelfHelpSimplifiedSolutionResource>> GetIfExistsAsync(string simplifiedSolutionsResourceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(simplifiedSolutionsResourceName, nameof(simplifiedSolutionsResourceName));

            using var scope = _selfHelpSimplifiedSolutionSimplifiedSolutionsClientDiagnostics.CreateScope("SelfHelpSimplifiedSolutionCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _selfHelpSimplifiedSolutionSimplifiedSolutionsRestClient.GetAsync(Id, simplifiedSolutionsResourceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SelfHelpSimplifiedSolutionResource>(response.GetRawResponse());
                return Response.FromValue(new SelfHelpSimplifiedSolutionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Help/simplifiedSolutions/{simplifiedSolutionsResourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SimplifiedSolutions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SelfHelpSimplifiedSolutionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="simplifiedSolutionsResourceName"> Simplified Solutions Resource Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="simplifiedSolutionsResourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="simplifiedSolutionsResourceName"/> is null. </exception>
        public virtual NullableResponse<SelfHelpSimplifiedSolutionResource> GetIfExists(string simplifiedSolutionsResourceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(simplifiedSolutionsResourceName, nameof(simplifiedSolutionsResourceName));

            using var scope = _selfHelpSimplifiedSolutionSimplifiedSolutionsClientDiagnostics.CreateScope("SelfHelpSimplifiedSolutionCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _selfHelpSimplifiedSolutionSimplifiedSolutionsRestClient.Get(Id, simplifiedSolutionsResourceName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SelfHelpSimplifiedSolutionResource>(response.GetRawResponse());
                return Response.FromValue(new SelfHelpSimplifiedSolutionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
