// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SelfHelp.Models;

namespace Azure.ResourceManager.SelfHelp
{
    /// <summary>
    /// A class representing the SelfHelpDiagnostic data model.
    /// Diagnostic resource
    /// </summary>
    public partial class SelfHelpDiagnosticData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SelfHelpDiagnosticData"/>. </summary>
        public SelfHelpDiagnosticData()
        {
            GlobalParameters = new ChangeTrackingDictionary<string, string>();
            Insights = new ChangeTrackingList<SelfHelpDiagnosticInvocation>();
            Diagnostics = new ChangeTrackingList<SelfHelpDiagnosticInfo>();
        }

        /// <summary> Initializes a new instance of <see cref="SelfHelpDiagnosticData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="globalParameters"> Global parameters is an optional map which can be used to add key and  value to request body to improve the diagnostics results. </param>
        /// <param name="insights"> SolutionIds that are needed to be invoked. </param>
        /// <param name="acceptedOn"> Diagnostic Request Accepted time. </param>
        /// <param name="provisioningState"> Status of diagnostic provisioning. </param>
        /// <param name="diagnostics"> Array of Diagnostics. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SelfHelpDiagnosticData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> globalParameters, IList<SelfHelpDiagnosticInvocation> insights, DateTimeOffset? acceptedOn, SelfHelpProvisioningState? provisioningState, IReadOnlyList<SelfHelpDiagnosticInfo> diagnostics, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            GlobalParameters = globalParameters;
            Insights = insights;
            AcceptedOn = acceptedOn;
            ProvisioningState = provisioningState;
            Diagnostics = diagnostics;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Global parameters is an optional map which can be used to add key and  value to request body to improve the diagnostics results. </summary>
        public IDictionary<string, string> GlobalParameters { get; }
        /// <summary> SolutionIds that are needed to be invoked. </summary>
        public IList<SelfHelpDiagnosticInvocation> Insights { get; }
        /// <summary> Diagnostic Request Accepted time. </summary>
        public DateTimeOffset? AcceptedOn { get; }
        /// <summary> Status of diagnostic provisioning. </summary>
        public SelfHelpProvisioningState? ProvisioningState { get; }
        /// <summary> Array of Diagnostics. </summary>
        public IReadOnlyList<SelfHelpDiagnosticInfo> Diagnostics { get; }
    }
}
