// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SelfHelp.Models
{
    /// <summary> Details of step input. </summary>
    public partial class TroubleshooterStepInput
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TroubleshooterStepInput"/>. </summary>
        internal TroubleshooterStepInput()
        {
            ResponseOptions = new ChangeTrackingList<ResponseConfig>();
        }

        /// <summary> Initializes a new instance of <see cref="TroubleshooterStepInput"/>. </summary>
        /// <param name="questionId"> Use Index as QuestionId. </param>
        /// <param name="questionType"> Type of Question. </param>
        /// <param name="questionTitle"> Question title. </param>
        /// <param name="questionContent"> User question content. </param>
        /// <param name="questionContentType"> Default is Text. </param>
        /// <param name="responseHint"> Place holder text for response hints. </param>
        /// <param name="recommendedOption"> Result of Automate step. </param>
        /// <param name="selectedOptionValue"> Text of response that was selected. </param>
        /// <param name="responseValidationProperties"> Troubleshooter step input response validation properties. </param>
        /// <param name="responseOptions"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TroubleshooterStepInput(string questionId, TroubleshooterQuestionType? questionType, string questionTitle, string questionContent, TroubleshooterQuestionContentType? questionContentType, string responseHint, string recommendedOption, string selectedOptionValue, ResponseValidationProperties responseValidationProperties, IReadOnlyList<ResponseConfig> responseOptions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            QuestionId = questionId;
            QuestionType = questionType;
            QuestionTitle = questionTitle;
            QuestionContent = questionContent;
            QuestionContentType = questionContentType;
            ResponseHint = responseHint;
            RecommendedOption = recommendedOption;
            SelectedOptionValue = selectedOptionValue;
            ResponseValidationProperties = responseValidationProperties;
            ResponseOptions = responseOptions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Use Index as QuestionId. </summary>
        public string QuestionId { get; }
        /// <summary> Type of Question. </summary>
        public TroubleshooterQuestionType? QuestionType { get; }
        /// <summary> Question title. </summary>
        public string QuestionTitle { get; }
        /// <summary> User question content. </summary>
        public string QuestionContent { get; }
        /// <summary> Default is Text. </summary>
        public TroubleshooterQuestionContentType? QuestionContentType { get; }
        /// <summary> Place holder text for response hints. </summary>
        public string ResponseHint { get; }
        /// <summary> Result of Automate step. </summary>
        public string RecommendedOption { get; }
        /// <summary> Text of response that was selected. </summary>
        public string SelectedOptionValue { get; }
        /// <summary> Troubleshooter step input response validation properties. </summary>
        public ResponseValidationProperties ResponseValidationProperties { get; }
        /// <summary> Gets the response options. </summary>
        public IReadOnlyList<ResponseConfig> ResponseOptions { get; }
    }
}
