// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SelfHelp.Models
{
    public partial class TroubleshooterStepInput : IUtf8JsonSerializable, IJsonModel<TroubleshooterStepInput>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<TroubleshooterStepInput>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<TroubleshooterStepInput>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TroubleshooterStepInput>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(TroubleshooterStepInput)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(QuestionId))
            {
                writer.WritePropertyName("questionId"u8);
                writer.WriteStringValue(QuestionId);
            }
            if (Optional.IsDefined(QuestionType))
            {
                writer.WritePropertyName("questionType"u8);
                writer.WriteStringValue(QuestionType.Value.ToString());
            }
            if (Optional.IsDefined(QuestionTitle))
            {
                writer.WritePropertyName("questionTitle"u8);
                writer.WriteStringValue(QuestionTitle);
            }
            if (Optional.IsDefined(QuestionContent))
            {
                writer.WritePropertyName("questionContent"u8);
                writer.WriteStringValue(QuestionContent);
            }
            if (Optional.IsDefined(QuestionContentType))
            {
                writer.WritePropertyName("questionContentType"u8);
                writer.WriteStringValue(QuestionContentType.Value.ToString());
            }
            if (Optional.IsDefined(ResponseHint))
            {
                writer.WritePropertyName("responseHint"u8);
                writer.WriteStringValue(ResponseHint);
            }
            if (Optional.IsDefined(RecommendedOption))
            {
                writer.WritePropertyName("recommendedOption"u8);
                writer.WriteStringValue(RecommendedOption);
            }
            if (Optional.IsDefined(SelectedOptionValue))
            {
                writer.WritePropertyName("selectedOptionValue"u8);
                writer.WriteStringValue(SelectedOptionValue);
            }
            if (Optional.IsDefined(ResponseValidationProperties))
            {
                writer.WritePropertyName("responseValidationProperties"u8);
                writer.WriteObjectValue(ResponseValidationProperties, options);
            }
            if (Optional.IsCollectionDefined(ResponseOptions))
            {
                writer.WritePropertyName("responseOptions"u8);
                writer.WriteStartArray();
                foreach (var item in ResponseOptions)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        TroubleshooterStepInput IJsonModel<TroubleshooterStepInput>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TroubleshooterStepInput>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(TroubleshooterStepInput)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeTroubleshooterStepInput(document.RootElement, options);
        }

        internal static TroubleshooterStepInput DeserializeTroubleshooterStepInput(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string questionId = default;
            TroubleshooterQuestionType? questionType = default;
            string questionTitle = default;
            string questionContent = default;
            TroubleshooterQuestionContentType? questionContentType = default;
            string responseHint = default;
            string recommendedOption = default;
            string selectedOptionValue = default;
            ResponseValidationProperties responseValidationProperties = default;
            IReadOnlyList<ResponseConfig> responseOptions = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("questionId"u8))
                {
                    questionId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("questionType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    questionType = new TroubleshooterQuestionType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("questionTitle"u8))
                {
                    questionTitle = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("questionContent"u8))
                {
                    questionContent = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("questionContentType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    questionContentType = new TroubleshooterQuestionContentType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("responseHint"u8))
                {
                    responseHint = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("recommendedOption"u8))
                {
                    recommendedOption = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("selectedOptionValue"u8))
                {
                    selectedOptionValue = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("responseValidationProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    responseValidationProperties = ResponseValidationProperties.DeserializeResponseValidationProperties(property.Value, options);
                    continue;
                }
                if (property.NameEquals("responseOptions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ResponseConfig> array = new List<ResponseConfig>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ResponseConfig.DeserializeResponseConfig(item, options));
                    }
                    responseOptions = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new TroubleshooterStepInput(
                questionId,
                questionType,
                questionTitle,
                questionContent,
                questionContentType,
                responseHint,
                recommendedOption,
                selectedOptionValue,
                responseValidationProperties,
                responseOptions ?? new ChangeTrackingList<ResponseConfig>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<TroubleshooterStepInput>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TroubleshooterStepInput>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(TroubleshooterStepInput)} does not support writing '{options.Format}' format.");
            }
        }

        TroubleshooterStepInput IPersistableModel<TroubleshooterStepInput>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TroubleshooterStepInput>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeTroubleshooterStepInput(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(TroubleshooterStepInput)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<TroubleshooterStepInput>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
