// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SelfHelp.Models
{
    /// <summary> Type of Question. </summary>
    public readonly partial struct TroubleshooterQuestionType : IEquatable<TroubleshooterQuestionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TroubleshooterQuestionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TroubleshooterQuestionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RadioButtonValue = "RadioButton";
        private const string DropdownValue = "Dropdown";
        private const string TextInputValue = "TextInput";
        private const string MultiLineInfoBoxValue = "MultiLineInfoBox";
        private const string DateTimePickerValue = "DateTimePicker";
        private const string MultiSelectValue = "MultiSelect";

        /// <summary> SingleChoice radio button. </summary>
        public static TroubleshooterQuestionType RadioButton { get; } = new TroubleshooterQuestionType(RadioButtonValue);
        /// <summary> SingleChoice dropdown. </summary>
        public static TroubleshooterQuestionType Dropdown { get; } = new TroubleshooterQuestionType(DropdownValue);
        /// <summary> Text Input. </summary>
        public static TroubleshooterQuestionType TextInput { get; } = new TroubleshooterQuestionType(TextInputValue);
        /// <summary> MultiLineInfoBox. </summary>
        public static TroubleshooterQuestionType MultiLineInfoBox { get; } = new TroubleshooterQuestionType(MultiLineInfoBoxValue);
        /// <summary> DateTime Picker. </summary>
        public static TroubleshooterQuestionType DateTimePicker { get; } = new TroubleshooterQuestionType(DateTimePickerValue);
        /// <summary> Multi Select. </summary>
        public static TroubleshooterQuestionType MultiSelect { get; } = new TroubleshooterQuestionType(MultiSelectValue);
        /// <summary> Determines if two <see cref="TroubleshooterQuestionType"/> values are the same. </summary>
        public static bool operator ==(TroubleshooterQuestionType left, TroubleshooterQuestionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TroubleshooterQuestionType"/> values are not the same. </summary>
        public static bool operator !=(TroubleshooterQuestionType left, TroubleshooterQuestionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TroubleshooterQuestionType"/>. </summary>
        public static implicit operator TroubleshooterQuestionType(string value) => new TroubleshooterQuestionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TroubleshooterQuestionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TroubleshooterQuestionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
