// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SelfHelp.Models
{
    /// <summary> Default is Text. </summary>
    public readonly partial struct TroubleshooterQuestionContentType : IEquatable<TroubleshooterQuestionContentType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TroubleshooterQuestionContentType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TroubleshooterQuestionContentType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TextValue = "Text";
        private const string HtmlValue = "Html";
        private const string MarkdownValue = "Markdown";

        /// <summary> Text. </summary>
        public static TroubleshooterQuestionContentType Text { get; } = new TroubleshooterQuestionContentType(TextValue);
        /// <summary> Html. </summary>
        public static TroubleshooterQuestionContentType Html { get; } = new TroubleshooterQuestionContentType(HtmlValue);
        /// <summary> Markdown. </summary>
        public static TroubleshooterQuestionContentType Markdown { get; } = new TroubleshooterQuestionContentType(MarkdownValue);
        /// <summary> Determines if two <see cref="TroubleshooterQuestionContentType"/> values are the same. </summary>
        public static bool operator ==(TroubleshooterQuestionContentType left, TroubleshooterQuestionContentType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TroubleshooterQuestionContentType"/> values are not the same. </summary>
        public static bool operator !=(TroubleshooterQuestionContentType left, TroubleshooterQuestionContentType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TroubleshooterQuestionContentType"/>. </summary>
        public static implicit operator TroubleshooterQuestionContentType(string value) => new TroubleshooterQuestionContentType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TroubleshooterQuestionContentType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TroubleshooterQuestionContentType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
