// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SelfHelp.Models
{
    /// <summary> Status of troubleshooter provisioning. </summary>
    public readonly partial struct TroubleshooterProvisioningState : IEquatable<TroubleshooterProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TroubleshooterProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TroubleshooterProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string RunningValue = "Running";
        private const string AutoContinueValue = "AutoContinue";

        /// <summary> Succeeded. </summary>
        public static TroubleshooterProvisioningState Succeeded { get; } = new TroubleshooterProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static TroubleshooterProvisioningState Failed { get; } = new TroubleshooterProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static TroubleshooterProvisioningState Canceled { get; } = new TroubleshooterProvisioningState(CanceledValue);
        /// <summary> Running. </summary>
        public static TroubleshooterProvisioningState Running { get; } = new TroubleshooterProvisioningState(RunningValue);
        /// <summary> AutoContinue. </summary>
        public static TroubleshooterProvisioningState AutoContinue { get; } = new TroubleshooterProvisioningState(AutoContinueValue);
        /// <summary> Determines if two <see cref="TroubleshooterProvisioningState"/> values are the same. </summary>
        public static bool operator ==(TroubleshooterProvisioningState left, TroubleshooterProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TroubleshooterProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(TroubleshooterProvisioningState left, TroubleshooterProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TroubleshooterProvisioningState"/>. </summary>
        public static implicit operator TroubleshooterProvisioningState(string value) => new TroubleshooterProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TroubleshooterProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TroubleshooterProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
