// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SelfHelp.Models
{
    /// <summary> Status of Troubleshooter Step execution. </summary>
    public readonly partial struct TroubleshooterExecutionStatus : IEquatable<TroubleshooterExecutionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TroubleshooterExecutionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TroubleshooterExecutionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SuccessValue = "Success";
        private const string RunningValue = "Running";
        private const string FailedValue = "Failed";
        private const string WarningValue = "Warning";

        /// <summary> Step execution succeeded. </summary>
        public static TroubleshooterExecutionStatus Success { get; } = new TroubleshooterExecutionStatus(SuccessValue);
        /// <summary> Step execution running. </summary>
        public static TroubleshooterExecutionStatus Running { get; } = new TroubleshooterExecutionStatus(RunningValue);
        /// <summary> Step execution failed. </summary>
        public static TroubleshooterExecutionStatus Failed { get; } = new TroubleshooterExecutionStatus(FailedValue);
        /// <summary> Step execution warning. </summary>
        public static TroubleshooterExecutionStatus Warning { get; } = new TroubleshooterExecutionStatus(WarningValue);
        /// <summary> Determines if two <see cref="TroubleshooterExecutionStatus"/> values are the same. </summary>
        public static bool operator ==(TroubleshooterExecutionStatus left, TroubleshooterExecutionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TroubleshooterExecutionStatus"/> values are not the same. </summary>
        public static bool operator !=(TroubleshooterExecutionStatus left, TroubleshooterExecutionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TroubleshooterExecutionStatus"/>. </summary>
        public static implicit operator TroubleshooterExecutionStatus(string value) => new TroubleshooterExecutionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TroubleshooterExecutionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TroubleshooterExecutionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
