// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SelfHelp.Models
{
    /// <summary> Solution replacement maps. </summary>
    public partial class SolutionReplacementMaps
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SolutionReplacementMaps"/>. </summary>
        internal SolutionReplacementMaps()
        {
            WebResults = new ChangeTrackingList<KBWebResult>();
            Diagnostics = new ChangeTrackingList<SolutionsDiagnostic>();
            Troubleshooters = new ChangeTrackingList<SolutionsTroubleshooters>();
            MetricsBasedCharts = new ChangeTrackingList<MetricsBasedChart>();
            Videos = new ChangeTrackingList<SelfHelpVideo>();
            VideoGroups = new ChangeTrackingList<VideoGroupDetail>();
        }

        /// <summary> Initializes a new instance of <see cref="SolutionReplacementMaps"/>. </summary>
        /// <param name="webResults"> Solution AzureKB results. </param>
        /// <param name="diagnostics"> Solution diagnostics results. </param>
        /// <param name="troubleshooters"> Solutions Troubleshooters. </param>
        /// <param name="metricsBasedCharts"> Solution metrics based charts. </param>
        /// <param name="videos"> Video solutions, which have the power to engage the customer by stimulating their senses. </param>
        /// <param name="videoGroups"> Group of Videos. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SolutionReplacementMaps(IReadOnlyList<KBWebResult> webResults, IReadOnlyList<SolutionsDiagnostic> diagnostics, IReadOnlyList<SolutionsTroubleshooters> troubleshooters, IReadOnlyList<MetricsBasedChart> metricsBasedCharts, IReadOnlyList<SelfHelpVideo> videos, IReadOnlyList<VideoGroupDetail> videoGroups, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            WebResults = webResults;
            Diagnostics = diagnostics;
            Troubleshooters = troubleshooters;
            MetricsBasedCharts = metricsBasedCharts;
            Videos = videos;
            VideoGroups = videoGroups;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Solution AzureKB results. </summary>
        public IReadOnlyList<KBWebResult> WebResults { get; }
        /// <summary> Solution diagnostics results. </summary>
        public IReadOnlyList<SolutionsDiagnostic> Diagnostics { get; }
        /// <summary> Solutions Troubleshooters. </summary>
        public IReadOnlyList<SolutionsTroubleshooters> Troubleshooters { get; }
        /// <summary> Solution metrics based charts. </summary>
        public IReadOnlyList<MetricsBasedChart> MetricsBasedCharts { get; }
        /// <summary> Video solutions, which have the power to engage the customer by stimulating their senses. </summary>
        public IReadOnlyList<SelfHelpVideo> Videos { get; }
        /// <summary> Group of Videos. </summary>
        public IReadOnlyList<VideoGroupDetail> VideoGroups { get; }
    }
}
