// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SelfHelp.Models
{
    /// <summary> Status of solution provisioning. </summary>
    public readonly partial struct SolutionProvisioningState : IEquatable<SolutionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SolutionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SolutionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string PartialCompleteValue = "PartialComplete";
        private const string FailedValue = "Failed";
        private const string RunningValue = "Running";
        private const string CanceledValue = "Canceled";

        /// <summary> All Solutions in the Batch succeeded. </summary>
        public static SolutionProvisioningState Succeeded { get; } = new SolutionProvisioningState(SucceededValue);
        /// <summary> Some Solutions are still running or failed. </summary>
        public static SolutionProvisioningState PartialComplete { get; } = new SolutionProvisioningState(PartialCompleteValue);
        /// <summary> All Solutions failed to run. </summary>
        public static SolutionProvisioningState Failed { get; } = new SolutionProvisioningState(FailedValue);
        /// <summary> All Solutions are still running. </summary>
        public static SolutionProvisioningState Running { get; } = new SolutionProvisioningState(RunningValue);
        /// <summary> When Solutions request gets canceled. </summary>
        public static SolutionProvisioningState Canceled { get; } = new SolutionProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="SolutionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(SolutionProvisioningState left, SolutionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SolutionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(SolutionProvisioningState left, SolutionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SolutionProvisioningState"/>. </summary>
        public static implicit operator SolutionProvisioningState(string value) => new SolutionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SolutionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SolutionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
