// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SelfHelp.Models
{
    /// <summary> Nlp Metadata resource. </summary>
    public partial class SolutionNlpMetadata : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SolutionNlpMetadata"/>. </summary>
        public SolutionNlpMetadata()
        {
            Solutions = new ChangeTrackingList<SolutionMetadataProperties>();
            RelatedServices = new ChangeTrackingList<ClassificationService>();
        }

        /// <summary> Initializes a new instance of <see cref="SolutionNlpMetadata"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="problemTitle"> Title of the problem classification. </param>
        /// <param name="problemDescription"> Description of the problem classification. </param>
        /// <param name="serviceId"> Id of the service (https://learn.microsoft.com/en-us/rest/api/support/services?view=rest-support-2020-04-01) that may be used to create a support ticket. </param>
        /// <param name="problemClassificationId"> Id of the ProblemClassification (https://learn.microsoft.com/en-us/rest/api/support/problem-classifications?view=rest-support-2020-04-01) that may be used to create a support ticket. </param>
        /// <param name="solutions"> The list of solution metadata. </param>
        /// <param name="relatedServices"> The set of services that are most likely related to the request. If relatedServices is included in the response then solutions may not be discovered until the client calls a second time specifying one of the service Ids in the relatedServices object. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SolutionNlpMetadata(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string problemTitle, string problemDescription, string serviceId, string problemClassificationId, IList<SolutionMetadataProperties> solutions, IList<ClassificationService> relatedServices, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ProblemTitle = problemTitle;
            ProblemDescription = problemDescription;
            ServiceId = serviceId;
            ProblemClassificationId = problemClassificationId;
            Solutions = solutions;
            RelatedServices = relatedServices;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Title of the problem classification. </summary>
        public string ProblemTitle { get; set; }
        /// <summary> Description of the problem classification. </summary>
        public string ProblemDescription { get; set; }
        /// <summary> Id of the service (https://learn.microsoft.com/en-us/rest/api/support/services?view=rest-support-2020-04-01) that may be used to create a support ticket. </summary>
        public string ServiceId { get; set; }
        /// <summary> Id of the ProblemClassification (https://learn.microsoft.com/en-us/rest/api/support/problem-classifications?view=rest-support-2020-04-01) that may be used to create a support ticket. </summary>
        public string ProblemClassificationId { get; set; }
        /// <summary> The list of solution metadata. </summary>
        public IList<SolutionMetadataProperties> Solutions { get; }
        /// <summary> The set of services that are most likely related to the request. If relatedServices is included in the response then solutions may not be discovered until the client calls a second time specifying one of the service Ids in the relatedServices object. </summary>
        public IList<ClassificationService> RelatedServices { get; }
    }
}
