// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SelfHelp.Models
{
    public partial class SolutionNlpMetadata : IUtf8JsonSerializable, IJsonModel<SolutionNlpMetadata>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SolutionNlpMetadata>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SolutionNlpMetadata>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SolutionNlpMetadata>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SolutionNlpMetadata)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(ProblemTitle))
            {
                writer.WritePropertyName("problemTitle"u8);
                writer.WriteStringValue(ProblemTitle);
            }
            if (Optional.IsDefined(ProblemDescription))
            {
                writer.WritePropertyName("problemDescription"u8);
                writer.WriteStringValue(ProblemDescription);
            }
            if (Optional.IsDefined(ServiceId))
            {
                writer.WritePropertyName("serviceId"u8);
                writer.WriteStringValue(ServiceId);
            }
            if (Optional.IsDefined(ProblemClassificationId))
            {
                writer.WritePropertyName("problemClassificationId"u8);
                writer.WriteStringValue(ProblemClassificationId);
            }
            if (Optional.IsCollectionDefined(Solutions))
            {
                writer.WritePropertyName("solutions"u8);
                writer.WriteStartArray();
                foreach (var item in Solutions)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(RelatedServices))
            {
                writer.WritePropertyName("relatedServices"u8);
                writer.WriteStartArray();
                foreach (var item in RelatedServices)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        SolutionNlpMetadata IJsonModel<SolutionNlpMetadata>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SolutionNlpMetadata>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SolutionNlpMetadata)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSolutionNlpMetadata(document.RootElement, options);
        }

        internal static SolutionNlpMetadata DeserializeSolutionNlpMetadata(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string problemTitle = default;
            string problemDescription = default;
            string serviceId = default;
            string problemClassificationId = default;
            IList<SolutionMetadataProperties> solutions = default;
            IList<ClassificationService> relatedServices = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("problemTitle"u8))
                        {
                            problemTitle = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("problemDescription"u8))
                        {
                            problemDescription = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("serviceId"u8))
                        {
                            serviceId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("problemClassificationId"u8))
                        {
                            problemClassificationId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("solutions"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<SolutionMetadataProperties> array = new List<SolutionMetadataProperties>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(SolutionMetadataProperties.DeserializeSolutionMetadataProperties(item, options));
                            }
                            solutions = array;
                            continue;
                        }
                        if (property0.NameEquals("relatedServices"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ClassificationService> array = new List<ClassificationService>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ClassificationService.DeserializeClassificationService(item, options));
                            }
                            relatedServices = array;
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SolutionNlpMetadata(
                id,
                name,
                type,
                systemData,
                problemTitle,
                problemDescription,
                serviceId,
                problemClassificationId,
                solutions ?? new ChangeTrackingList<SolutionMetadataProperties>(),
                relatedServices ?? new ChangeTrackingList<ClassificationService>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SolutionNlpMetadata>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SolutionNlpMetadata>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SolutionNlpMetadata)} does not support writing '{options.Format}' format.");
            }
        }

        SolutionNlpMetadata IPersistableModel<SolutionNlpMetadata>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SolutionNlpMetadata>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSolutionNlpMetadata(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SolutionNlpMetadata)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SolutionNlpMetadata>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
