// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SelfHelp.Models
{
    /// <summary> Metadata Properties. </summary>
    public partial class SolutionMetadataProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SolutionMetadataProperties"/>. </summary>
        public SolutionMetadataProperties()
        {
            RequiredInputs = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="SolutionMetadataProperties"/>. </summary>
        /// <param name="solutionId"> Solution Id. </param>
        /// <param name="solutionType"> Solution Type. </param>
        /// <param name="description"> A detailed description of solution. </param>
        /// <param name="requiredInputs"> Required parameters for invoking this particular solution. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SolutionMetadataProperties(string solutionId, SelfHelpSolutionType? solutionType, string description, IReadOnlyList<string> requiredInputs, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SolutionId = solutionId;
            SolutionType = solutionType;
            Description = description;
            RequiredInputs = requiredInputs;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Solution Id. </summary>
        public string SolutionId { get; set; }
        /// <summary> Solution Type. </summary>
        public SelfHelpSolutionType? SolutionType { get; }
        /// <summary> A detailed description of solution. </summary>
        public string Description { get; }
        /// <summary> Required parameters for invoking this particular solution. </summary>
        public IReadOnlyList<string> RequiredInputs { get; }
    }
}
