// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SelfHelp.Models
{
    public partial class SelfHelpStep : IUtf8JsonSerializable, IJsonModel<SelfHelpStep>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SelfHelpStep>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SelfHelpStep>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SelfHelpStep>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SelfHelpStep)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Id))
            {
                writer.WritePropertyName("id"u8);
                writer.WriteStringValue(Id);
            }
            if (Optional.IsDefined(Title))
            {
                writer.WritePropertyName("title"u8);
                writer.WriteStringValue(Title);
            }
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (Optional.IsDefined(Guidance))
            {
                writer.WritePropertyName("guidance"u8);
                writer.WriteStringValue(Guidance);
            }
            if (Optional.IsDefined(ExecutionStatus))
            {
                writer.WritePropertyName("executionStatus"u8);
                writer.WriteStringValue(ExecutionStatus.Value.ToString());
            }
            if (Optional.IsDefined(ExecutionStatusDescription))
            {
                writer.WritePropertyName("executionStatusDescription"u8);
                writer.WriteStringValue(ExecutionStatusDescription);
            }
            if (Optional.IsDefined(StepType))
            {
                writer.WritePropertyName("type"u8);
                writer.WriteStringValue(StepType.Value.ToString());
            }
            if (Optional.IsDefined(IsLastStep))
            {
                writer.WritePropertyName("isLastStep"u8);
                writer.WriteBooleanValue(IsLastStep.Value);
            }
            if (Optional.IsCollectionDefined(Inputs))
            {
                writer.WritePropertyName("inputs"u8);
                writer.WriteStartArray();
                foreach (var item in Inputs)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(AutomatedCheckResults))
            {
                writer.WritePropertyName("automatedCheckResults"u8);
                writer.WriteObjectValue(AutomatedCheckResults, options);
            }
            if (Optional.IsCollectionDefined(Insights))
            {
                writer.WritePropertyName("insights"u8);
                writer.WriteStartArray();
                foreach (var item in Insights)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Error))
            {
                writer.WritePropertyName("error"u8);
                JsonSerializer.Serialize(writer, Error);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SelfHelpStep IJsonModel<SelfHelpStep>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SelfHelpStep>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SelfHelpStep)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSelfHelpStep(document.RootElement, options);
        }

        internal static SelfHelpStep DeserializeSelfHelpStep(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string id = default;
            string title = default;
            string description = default;
            string guidance = default;
            TroubleshooterExecutionStatus? executionStatus = default;
            string executionStatusDescription = default;
            SelfHelpType? type = default;
            bool? isLastStep = default;
            IReadOnlyList<TroubleshooterStepInput> inputs = default;
            AutomatedCheckResult automatedCheckResults = default;
            IReadOnlyList<SelfHelpDiagnosticInsight> insights = default;
            ResponseError error = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("title"u8))
                {
                    title = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("description"u8))
                {
                    description = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("guidance"u8))
                {
                    guidance = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("executionStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    executionStatus = new TroubleshooterExecutionStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("executionStatusDescription"u8))
                {
                    executionStatusDescription = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    type = new SelfHelpType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("isLastStep"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isLastStep = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("inputs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<TroubleshooterStepInput> array = new List<TroubleshooterStepInput>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(TroubleshooterStepInput.DeserializeTroubleshooterStepInput(item, options));
                    }
                    inputs = array;
                    continue;
                }
                if (property.NameEquals("automatedCheckResults"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    automatedCheckResults = AutomatedCheckResult.DeserializeAutomatedCheckResult(property.Value, options);
                    continue;
                }
                if (property.NameEquals("insights"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SelfHelpDiagnosticInsight> array = new List<SelfHelpDiagnosticInsight>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SelfHelpDiagnosticInsight.DeserializeSelfHelpDiagnosticInsight(item, options));
                    }
                    insights = array;
                    continue;
                }
                if (property.NameEquals("error"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    error = JsonSerializer.Deserialize<ResponseError>(property.Value.GetRawText());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SelfHelpStep(
                id,
                title,
                description,
                guidance,
                executionStatus,
                executionStatusDescription,
                type,
                isLastStep,
                inputs ?? new ChangeTrackingList<TroubleshooterStepInput>(),
                automatedCheckResults,
                insights ?? new ChangeTrackingList<SelfHelpDiagnosticInsight>(),
                error,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SelfHelpStep>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SelfHelpStep>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SelfHelpStep)} does not support writing '{options.Format}' format.");
            }
        }

        SelfHelpStep IPersistableModel<SelfHelpStep>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SelfHelpStep>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSelfHelpStep(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SelfHelpStep)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SelfHelpStep>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
