// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SelfHelp.Models
{
    /// <summary> Part of the solution and are dividers in the solution rendering. </summary>
    public partial class SelfHelpSection
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SelfHelpSection"/>. </summary>
        internal SelfHelpSection()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SelfHelpSection"/>. </summary>
        /// <param name="title"> Solution sections title. </param>
        /// <param name="content"> Solution sections content. </param>
        /// <param name="replacementMaps"> Solution replacement maps. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SelfHelpSection(string title, string content, SolutionReplacementMaps replacementMaps, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Title = title;
            Content = content;
            ReplacementMaps = replacementMaps;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Solution sections title. </summary>
        public string Title { get; }
        /// <summary> Solution sections content. </summary>
        public string Content { get; }
        /// <summary> Solution replacement maps. </summary>
        public SolutionReplacementMaps ReplacementMaps { get; }
    }
}
