// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SelfHelp.Models
{
    /// <summary> Status of diagnostic provisioning. </summary>
    public readonly partial struct SelfHelpProvisioningState : IEquatable<SelfHelpProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SelfHelpProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SelfHelpProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string PartialCompleteValue = "PartialComplete";
        private const string FailedValue = "Failed";
        private const string RunningValue = "Running";
        private const string CanceledValue = "Canceled";

        /// <summary> All Diagnostics in the Batch succeeded. </summary>
        public static SelfHelpProvisioningState Succeeded { get; } = new SelfHelpProvisioningState(SucceededValue);
        /// <summary> Some Diagnostics are still running or failed. </summary>
        public static SelfHelpProvisioningState PartialComplete { get; } = new SelfHelpProvisioningState(PartialCompleteValue);
        /// <summary> All Diagnostics failed to run. </summary>
        public static SelfHelpProvisioningState Failed { get; } = new SelfHelpProvisioningState(FailedValue);
        /// <summary> All Diagnostics are still running. </summary>
        public static SelfHelpProvisioningState Running { get; } = new SelfHelpProvisioningState(RunningValue);
        /// <summary> When Diagnostic request gets canceled. </summary>
        public static SelfHelpProvisioningState Canceled { get; } = new SelfHelpProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="SelfHelpProvisioningState"/> values are the same. </summary>
        public static bool operator ==(SelfHelpProvisioningState left, SelfHelpProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SelfHelpProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(SelfHelpProvisioningState left, SelfHelpProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SelfHelpProvisioningState"/>. </summary>
        public static implicit operator SelfHelpProvisioningState(string value) => new SelfHelpProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SelfHelpProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SelfHelpProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
