// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SelfHelp.Models
{
    /// <summary> Trigger criterion name. </summary>
    public readonly partial struct SelfHelpName : IEquatable<SelfHelpName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SelfHelpName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SelfHelpName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SolutionIdValue = "SolutionId";
        private const string ProblemClassificationIdValue = "ProblemClassificationId";
        private const string ReplacementKeyValue = "ReplacementKey";

        /// <summary> SolutionId. </summary>
        public static SelfHelpName SolutionId { get; } = new SelfHelpName(SolutionIdValue);
        /// <summary> ProblemClassificationId. </summary>
        public static SelfHelpName ProblemClassificationId { get; } = new SelfHelpName(ProblemClassificationIdValue);
        /// <summary> ReplacementKey. </summary>
        public static SelfHelpName ReplacementKey { get; } = new SelfHelpName(ReplacementKeyValue);
        /// <summary> Determines if two <see cref="SelfHelpName"/> values are the same. </summary>
        public static bool operator ==(SelfHelpName left, SelfHelpName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SelfHelpName"/> values are not the same. </summary>
        public static bool operator !=(SelfHelpName left, SelfHelpName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SelfHelpName"/>. </summary>
        public static implicit operator SelfHelpName(string value) => new SelfHelpName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SelfHelpName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SelfHelpName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
