// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SelfHelp.Models
{
    /// <summary> Denotes the status of the diagnostic resource. </summary>
    public readonly partial struct SelfHelpDiagnosticStatus : IEquatable<SelfHelpDiagnosticStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SelfHelpDiagnosticStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SelfHelpDiagnosticStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FailedValue = "Failed";
        private const string MissingInputsValue = "MissingInputs";
        private const string RunningValue = "Running";
        private const string SucceededValue = "Succeeded";
        private const string TimeoutValue = "Timeout";

        /// <summary> Diagnostic creation failed. </summary>
        public static SelfHelpDiagnosticStatus Failed { get; } = new SelfHelpDiagnosticStatus(FailedValue);
        /// <summary> Request is missing required inputs to run. </summary>
        public static SelfHelpDiagnosticStatus MissingInputs { get; } = new SelfHelpDiagnosticStatus(MissingInputsValue);
        /// <summary> Diagnostic is still running. </summary>
        public static SelfHelpDiagnosticStatus Running { get; } = new SelfHelpDiagnosticStatus(RunningValue);
        /// <summary> Diagnostic creation succeeded. </summary>
        public static SelfHelpDiagnosticStatus Succeeded { get; } = new SelfHelpDiagnosticStatus(SucceededValue);
        /// <summary> Diagnostic was timed out. </summary>
        public static SelfHelpDiagnosticStatus Timeout { get; } = new SelfHelpDiagnosticStatus(TimeoutValue);
        /// <summary> Determines if two <see cref="SelfHelpDiagnosticStatus"/> values are the same. </summary>
        public static bool operator ==(SelfHelpDiagnosticStatus left, SelfHelpDiagnosticStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SelfHelpDiagnosticStatus"/> values are not the same. </summary>
        public static bool operator !=(SelfHelpDiagnosticStatus left, SelfHelpDiagnosticStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SelfHelpDiagnosticStatus"/>. </summary>
        public static implicit operator SelfHelpDiagnosticStatus(string value) => new SelfHelpDiagnosticStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SelfHelpDiagnosticStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SelfHelpDiagnosticStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
