// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SelfHelp.Models
{
    /// <summary> Properties returned with in an insight. </summary>
    public partial class SelfHelpDiagnosticInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SelfHelpDiagnosticInfo"/>. </summary>
        internal SelfHelpDiagnosticInfo()
        {
            Insights = new ChangeTrackingList<SelfHelpDiagnosticInsight>();
        }

        /// <summary> Initializes a new instance of <see cref="SelfHelpDiagnosticInfo"/>. </summary>
        /// <param name="solutionId"> Solution Id. </param>
        /// <param name="status"> Denotes the status of the diagnostic resource. </param>
        /// <param name="insights"> The problems (if any) detected by this insight. </param>
        /// <param name="error"> Error definition. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SelfHelpDiagnosticInfo(string solutionId, SelfHelpDiagnosticStatus? status, IReadOnlyList<SelfHelpDiagnosticInsight> insights, SelfHelpError error, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SolutionId = solutionId;
            Status = status;
            Insights = insights;
            Error = error;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Solution Id. </summary>
        public string SolutionId { get; }
        /// <summary> Denotes the status of the diagnostic resource. </summary>
        public SelfHelpDiagnosticStatus? Status { get; }
        /// <summary> The problems (if any) detected by this insight. </summary>
        public IReadOnlyList<SelfHelpDiagnosticInsight> Insights { get; }
        /// <summary> Error definition. </summary>
        public SelfHelpError Error { get; }
    }
}
