// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SelfHelp.Models
{
    /// <summary> Confidence of the search result. </summary>
    public readonly partial struct SelfHelpConfidence : IEquatable<SelfHelpConfidence>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SelfHelpConfidence"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SelfHelpConfidence(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LowValue = "Low";
        private const string MediumValue = "Medium";
        private const string HighValue = "High";

        /// <summary> Low. </summary>
        public static SelfHelpConfidence Low { get; } = new SelfHelpConfidence(LowValue);
        /// <summary> Medium. </summary>
        public static SelfHelpConfidence Medium { get; } = new SelfHelpConfidence(MediumValue);
        /// <summary> High. </summary>
        public static SelfHelpConfidence High { get; } = new SelfHelpConfidence(HighValue);
        /// <summary> Determines if two <see cref="SelfHelpConfidence"/> values are the same. </summary>
        public static bool operator ==(SelfHelpConfidence left, SelfHelpConfidence right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SelfHelpConfidence"/> values are not the same. </summary>
        public static bool operator !=(SelfHelpConfidence left, SelfHelpConfidence right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SelfHelpConfidence"/>. </summary>
        public static implicit operator SelfHelpConfidence(string value) => new SelfHelpConfidence(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SelfHelpConfidence other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SelfHelpConfidence other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
