// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SelfHelp.Models
{
    /// <summary> Troubleshooter step input response validation properties. </summary>
    public partial class ResponseValidationProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResponseValidationProperties"/>. </summary>
        internal ResponseValidationProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ResponseValidationProperties"/>. </summary>
        /// <param name="regex"> Regex used for the input validation. </param>
        /// <param name="validationScope"> Validation scope. </param>
        /// <param name="isRequired"> Default True. </param>
        /// <param name="validationErrorMessage"> Validation Error Message. </param>
        /// <param name="maxLength"> Max text input (open Ended Text). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResponseValidationProperties(string regex, TroubleshooterValidationScope? validationScope, bool? isRequired, string validationErrorMessage, long? maxLength, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Regex = regex;
            ValidationScope = validationScope;
            IsRequired = isRequired;
            ValidationErrorMessage = validationErrorMessage;
            MaxLength = maxLength;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Regex used for the input validation. </summary>
        public string Regex { get; }
        /// <summary> Validation scope. </summary>
        public TroubleshooterValidationScope? ValidationScope { get; }
        /// <summary> Default True. </summary>
        public bool? IsRequired { get; }
        /// <summary> Validation Error Message. </summary>
        public string ValidationErrorMessage { get; }
        /// <summary> Max text input (open Ended Text). </summary>
        public long? MaxLength { get; }
    }
}
