// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SelfHelp.Models
{
    /// <summary> Solutions metrics based chart. </summary>
    public partial class MetricsBasedChart
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MetricsBasedChart"/>. </summary>
        internal MetricsBasedChart()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MetricsBasedChart"/>. </summary>
        /// <param name="name"> Chart name. </param>
        /// <param name="aggregationType"> Allowed values are Sum, Avg, Count, Min, Max. Default is Sum. </param>
        /// <param name="timeSpanDuration"> Time span duration. </param>
        /// <param name="title"> Chart title. </param>
        /// <param name="filterGroup"> Filter group. </param>
        /// <param name="replacementKey"> Place holder used in HTML Content replace control with the content. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MetricsBasedChart(string name, ChartAggregationType? aggregationType, TimeSpan? timeSpanDuration, string title, ChartFilterGroup filterGroup, string replacementKey, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            AggregationType = aggregationType;
            TimeSpanDuration = timeSpanDuration;
            Title = title;
            FilterGroup = filterGroup;
            ReplacementKey = replacementKey;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Chart name. </summary>
        public string Name { get; }
        /// <summary> Allowed values are Sum, Avg, Count, Min, Max. Default is Sum. </summary>
        public ChartAggregationType? AggregationType { get; }
        /// <summary> Time span duration. </summary>
        public TimeSpan? TimeSpanDuration { get; }
        /// <summary> Chart title. </summary>
        public string Title { get; }
        /// <summary> Filter group. </summary>
        internal ChartFilterGroup FilterGroup { get; }
        /// <summary> List of filters. </summary>
        public IReadOnlyList<SelfHelpFilter> Filter
        {
            get => FilterGroup?.Filter;
        }

        /// <summary> Place holder used in HTML Content replace control with the content. </summary>
        public string ReplacementKey { get; }
    }
}
